/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.melsynthesis;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.JPanelTableFolder;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTPanelTableFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class MELSynthesisTableFolder
extends FTPanelTableFolder {
    private static final String TAG_CECILIA_MELSYNTHESIS = "cecilia.folders";

    protected MELSynthesisTableFolder(CAppl cAppl, JDialog dlg, List<DBFolder> folders) {
        super(cAppl, dlg);
        this.initialise();
        this.getModel().setFolders(folders);
        this.getModel().fireTableDataChanged();
    }

    @Override
    protected JPanel createBottomPanel() {
        return null;
    }

    @Override
    public void deleteRows() {
        int i;
        int[] selectedRows = this._table.getSelectedRows();
        ArrayList<Integer> foldersToDelete = new ArrayList<Integer>();
        for (i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            foldersToDelete.add(this._table.convertRowIndexToModel(selectedRow));
        }
        Collections.sort(foldersToDelete);
        for (i = foldersToDelete.size() - 1; i >= 0; --i) {
            int selectedFolder = (Integer)foldersToDelete.get(i);
            this.getModel().getFolders().remove(this._table.convertRowIndexToModel(selectedFolder));
        }
        this.getModel().fireTableDataChanged();
    }

    @Override
    protected void addToBatch(DBFolder node) {
        if (this.getModel().getFolders().contains(node)) {
            return;
        }
        this.getModel().getFolders().add(node);
        int newSize = this.getModel().getFolders().size();
        this.getModel().fireTableRowsInserted(newSize - 1, newSize);
    }

    private JPanelTableFolder.DBFolderModel getModel() {
        return (JPanelTableFolder.DBFolderModel)this._model;
    }

    public List<DBFolder> getFolders() {
        return this.getModel().getFolders();
    }

    @Override
    public void save(File output) {
        this.doSave(output, TAG_CECILIA_MELSYNTHESIS, this.getFolders());
    }

    @Override
    public void load(File input) {
        this.getFolders().clear();
        this.doLoad(input, null);
        this.getModel().fireTableDataChanged();
    }

    @Override
    protected void doLoadFolder(DBFolder dbFolder, Element elem) {
        this.getFolders().add(dbFolder);
    }
}

