/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CAASelectorPanel
extends JPanel {
    static final int PROP_DEF_TREE_COMPUTE_CAA_LEVEL = 2;
    static final String PROP_TREE_COMPUTE_CAA_LEVEL = "cecilia.ft.compute.CAALevel";
    static final int __level = Integer.getInteger("cecilia.ft.compute.CAALevel", 2);
    List<Attr.Key> _attributes;
    List<CAAAttributePanel> _panels;
    JCheckBox _ctrlMerge;
    JPanel _ctrlCenter = new JPanel(new GridLayout(0, 1));

    public CAASelectorPanel() {
        super(new BorderLayout());
        int level = __level > 10 ? 10 : (__level <= 0 ? 1 : __level);
        this._panels = new ArrayList<CAAAttributePanel>(level);
        CAAAttributePanel next = null;
        for (int i = level; i > 0; --i) {
            CAAAttributePanel panel = new CAAAttributePanel(i, next);
            this._panels.add(panel);
            next = panel;
        }
        Collections.reverse(this._panels);
        for (CAAAttributePanel panel : this._panels) {
            this._ctrlCenter.add(panel);
        }
        this._panels.get((int)0)._ctrlCheck.setEnabled(false);
        this._panels.get((int)0)._ctrlCheck.setSelected(true);
        this._panels.get(0).refreshCtrlCheck();
        this.add((Component)this._ctrlCenter, "Center");
        this._ctrlMerge = new JCheckBox(ResCompute.getString("CAA_MERGE_VALUES"));
        this.add((Component)this._ctrlMerge, "South");
    }

    public boolean verifyParameters() {
        int len = this._panels.size();
        LinkedHashSet<Attr.Key> keys = new LinkedHashSet<Attr.Key>();
        for (int i = 0; i < len; ++i) {
            CAAAttributePanel panel = this._panels.get(i);
            if (!panel._ctrlCheck.isSelected()) {
                return true;
            }
            Object select = panel._ctrlAttributes.getSelectedItem();
            if (select == null || !(select instanceof Attr.Key)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(panel._ctrlAttributes), ResCompute.getString("CAA_DLG_ERR_EMPTY_SELECT"), ResCompute.getString("CAA_DLG_EDIT_TITLE"), 0);
                panel._ctrlAttributes.requestFocus();
                return false;
            }
            if (keys.contains(select)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(panel._ctrlAttributes), ResCompute.msgFormat("CAA_DLG_ERR_EMPTY_SELECT", ((Attr.Key)select).getName()), ResCompute.getString("CAA_DLG_EDIT_TITLE"), 0);
                panel._ctrlAttributes.requestFocus();
                return false;
            }
            keys.add((Attr.Key)select);
        }
        return true;
    }

    public void setAttributes(Map<Attr.Key, Set<String>> attributes) {
        this._attributes = new ArrayList<Attr.Key>(attributes.keySet());
    }

    public void setSelectors(Collection<Attr.Key> selectors) {
        int idx;
        if (selectors != null) {
            Iterator<Attr.Key> iAttr = selectors.iterator();
            for (idx = 0; iAttr.hasNext() && idx < this._panels.size(); ++idx) {
                Attr.Key attr = iAttr.next();
                CAAAttributePanel panel = this._panels.get(idx);
                panel._ctrlCheck.setSelected(true);
                panel._ctrlAttributes.setSelectedItem(attr);
            }
        }
        while (idx < this._panels.size()) {
            CAAAttributePanel panel = this._panels.get(idx);
            panel._ctrlCheck.setSelected(false);
            panel._ctrlAttributes.setSelectedItem(null);
            ++idx;
        }
        if (!this._panels.isEmpty()) {
            this._panels.get((int)0)._ctrlCheck.setSelected(true);
        }
    }

    public Collection<Attr.Key> getSelectors() {
        int len = this._panels.size();
        LinkedHashSet<Attr.Key> keys = new LinkedHashSet<Attr.Key>();
        for (int i = 0; i < len; ++i) {
            CAAAttributePanel panel = this._panels.get(i);
            if (!panel._ctrlCheck.isSelected()) {
                return keys;
            }
            Object select = panel._ctrlAttributes.getSelectedItem();
            if (select == null || !(select instanceof Attr.Key)) {
                return null;
            }
            if (keys.contains(select)) {
                return null;
            }
            keys.add((Attr.Key)select);
        }
        return keys;
    }

    public void setMergeValue(boolean value) {
        this._ctrlMerge.setSelected(value);
    }

    public boolean isMergeValue() {
        return this._ctrlMerge.isSelected();
    }

    public void refreshCtrl() {
        CAAAttributePanel caaPanel;
        while (this._panels.size() > this._attributes.size()) {
            caaPanel = this._panels.remove(this._panels.size() - 1);
            this._ctrlCenter.remove(caaPanel);
        }
        if (this._panels.size() == 0) {
            return;
        }
        caaPanel = this._panels.get(this._panels.size() - 1);
        caaPanel._next = null;
        if (this._attributes.size() == 1) {
            this._panels.get((int)0)._ctrlAttributes.setSelectedItem(this._attributes.get(0));
        }
        this._panels.get(0).refreshCtrlCheck();
    }

    class CAAAttributePanel
    extends JPanel {
        JCheckBox _ctrlCheck;
        CAAComboBox _ctrlAttributes;
        JLabel _ctrlType;
        JLabel _lblName;
        JLabel _lblType;
        CAAAttributePanel _next;

        public CAAAttributePanel(int level, CAAAttributePanel next) {
            super(new ToggleBorderLayout());
            this._ctrlCheck = new JCheckBox(ResCompute.msgFormat("CAA_ATTRIBUTE_LEVEL", level));
            this._lblType = new JLabel(ResMsgVoc.getString("VOC_TYPE"));
            this._lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
            this._ctrlType = new JLabel("0121345678901");
            this._ctrlAttributes = new CAAComboBox(level, this._ctrlType);
            this._next = next;
            JPanel selectPanel = new JPanel(new GridBagLayout());
            selectPanel.add((Component)this._lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            selectPanel.add((Component)this._ctrlAttributes, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            selectPanel.add((Component)this._lblType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            selectPanel.add((Component)this._ctrlType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            ToggleBorderLayout.configure(this, this._ctrlCheck, selectPanel);
            this._ctrlCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CAAAttributePanel.this.refreshCtrlCheck();
                }
            });
            this._ctrlCheck.setEnabled(false);
        }

        protected void refreshCtrlCheck() {
            boolean selected = this._ctrlCheck.isSelected();
            this._lblName.setEnabled(selected);
            this._ctrlAttributes.setEnabled(selected);
            this._ctrlAttributes.refreshCtrlType();
            this._lblType.setEnabled(selected);
            this._ctrlType.setEnabled(selected);
            if (this._next != null) {
                this._next._ctrlCheck.setEnabled(selected);
                if (!selected) {
                    this._next._ctrlCheck.setSelected(false);
                }
                this._next.refreshCtrlCheck();
            }
        }
    }

    class CAAComboBox
    extends JComboBox {
        int _level;
        JLabel _ctrlType;

        public CAAComboBox(int level, JLabel lblType) {
            super(new CAAModelComboBox());
            this._level = level;
            this._ctrlType = lblType;
            this.setEditable(false);
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        boolean alreadySelected = false;
                        for (int i = 0; i < CAAComboBox.this._level - 1 && i < CAASelectorPanel.this._panels.size(); ++i) {
                            if (!value.equals(CAASelectorPanel.this._panels.get((int)i)._ctrlAttributes.getSelectedItem())) continue;
                            alreadySelected = true;
                            break;
                        }
                        if (alreadySelected) {
                            this.setForeground(Color.red);
                        } else {
                            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                        }
                    }
                    if (value instanceof Attr.Key) {
                        this.setText(((Attr.Key)value).getName());
                    }
                    return this;
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CAAComboBox.this.refreshCtrlType();
                }
            });
        }

        protected void refreshCtrlType() {
            Object selectItem = this.getSelectedItem();
            if (selectItem == null || !(selectItem instanceof Attr.Key)) {
                this._ctrlType.setText("");
            } else {
                this._ctrlType.setText(((Attr.Key)selectItem).getType().getLabel());
            }
        }
    }

    class CAAModelComboBox
    extends AbstractListModel
    implements ComboBoxModel {
        Object _selectedObject;

        CAAModelComboBox() {
        }

        @Override
        public int getSize() {
            return CAASelectorPanel.this._attributes == null ? 0 : CAASelectorPanel.this._attributes.size();
        }

        @Override
        public Object getElementAt(int index) {
            return CAASelectorPanel.this._attributes.get(index);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this._selectedObject != null && !this._selectedObject.equals(anObject) || this._selectedObject == null && anObject != null) {
                this._selectedObject = anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this._selectedObject;
        }
    }
}

