/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResultTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.CriticityResultTableModelFromStore;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class CriticityResultPanel
extends JPanel {
    private final ArborRenderer _renderer;
    private final AbstractTableModel _model;

    public CriticityResultPanel(BooleanStore store, BooleanResult result, ArborRenderer renderer) {
        super(new GridBagLayout());
        this._renderer = renderer;
        this._model = new CriticityResultTableModelFromStore(result.getCriticityResult(), store, this._renderer);
        this.createPanel();
        this.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_CRITICITY")));
    }

    private final void createPanel() {
        JTable table = new JTable(this._model);
        table.setDefaultRenderer(CriticityResult.OKKO.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tablee, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(tablee, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return this;
                }
                if (value == CriticityResult.OKKO.KO) {
                    this.setForeground(Color.RED);
                } else if (value == CriticityResult.OKKO.OK) {
                    this.setForeground(Color.GREEN);
                } else if (value == CriticityResult.OKKO.NaN) {
                    this.setForeground(Color.BLACK);
                }
                this.setToolTipText(value.toString());
                return this;
            }
        });
        table.setDefaultRenderer(Number.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tablee, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(tablee, value, isSelected, hasFocus, row, column);
                this.setHorizontalAlignment(2);
                if (value != null && !(value instanceof Integer) && value instanceof Double) {
                    this.setText(CriticityResultPanel.this._renderer.formatNumber((Double)value));
                    this.setToolTipText(value.toString());
                }
                return this;
            }
        });
        table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tablee, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(tablee, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return this;
                }
                try {
                    String valStr = value.toString();
                    if (valStr.indexOf(46) == -1) {
                        this.setToolTipText(null);
                        return this;
                    }
                    if (valStr.indexOf(40) != -1) {
                        String newValStr = CriticityResultTableModel.convertLatentInformations(valStr, CriticityResultPanel.this._renderer);
                        this.setText(newValStr);
                        this.setToolTipText(valStr);
                    } else {
                        double d = Double.parseDouble(valStr);
                        this.setText(CriticityResultPanel.this._renderer.formatProbability(d));
                        this.setToolTipText(valStr);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return this;
            }
        });
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void refresh() {
        this._model.fireTableDataChanged();
    }
}

