/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTablePanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MCSOrdersWithFilterTableModel
implements TableModel,
MCSTablePanel.MCSFilterListener {
    boolean _withProbability = true;
    boolean _filter = false;
    int[] _fullOrdersNumber;
    double[] _fullOrdersProbability;
    int[] _filterOrdersNumber;
    double[] _filterOrdersProbability;
    protected List<TableModelListener> _tableModelListenerList = new ArrayList<TableModelListener>();

    public MCSOrdersWithFilterTableModel(MCS mcs) {
        int orderMax = mcs.getOrderMax();
        this._fullOrdersNumber = new int[orderMax];
        this._fullOrdersProbability = new double[orderMax];
        this._filterOrdersNumber = new int[orderMax];
        this._filterOrdersProbability = new double[orderMax];
        if (orderMax > 0) {
            int sumNumber = 0;
            double sumProba = 0.0;
            for (int i = 1; i < orderMax; ++i) {
                int n = mcs.getOrderNumber(i);
                this._filterOrdersNumber[i - 1] = n;
                this._fullOrdersNumber[i - 1] = n;
                sumNumber += n;
                double d = mcs.getOrderProbability(i);
                this._filterOrdersProbability[i - 1] = d;
                this._fullOrdersProbability[i - 1] = d;
                sumProba += d;
            }
            int n = sumNumber;
            this._filterOrdersNumber[orderMax - 1] = n;
            this._fullOrdersNumber[orderMax - 1] = n;
            double d = sumProba;
            this._filterOrdersProbability[orderMax - 1] = d;
            this._fullOrdersProbability[orderMax - 1] = d;
        }
    }

    public void setWithProbability(boolean value) {
        this._withProbability = value;
    }

    @Override
    public void changeTable(MCS mcs, MCSFilter filter) {
        int i;
        int orderMCSMax = mcs.getOrderMax();
        if (orderMCSMax == 0) {
            orderMCSMax = 1;
        }
        int orderMax = this._fullOrdersNumber.length;
        int sumNumber = 0;
        double sumProba = 0.0;
        for (i = 1; i < orderMCSMax; ++i) {
            int n = mcs.getOrderNumber(i);
            this._filterOrdersNumber[i - 1] = n;
            sumNumber += n;
            double d = mcs.getOrderProbability(i);
            this._filterOrdersProbability[i - 1] = d;
            sumProba += d;
        }
        for (i = orderMCSMax; i < orderMax; ++i) {
            this._filterOrdersNumber[i - 1] = 0;
            this._filterOrdersProbability[i - 1] = 0.0;
        }
        if (orderMax > 0) {
            this._filterOrdersNumber[orderMax - 1] = sumNumber;
            this._filterOrdersProbability[orderMax - 1] = sumProba;
        }
        boolean oldFilter = this._filter;
        boolean bl = this._filter = filter != null;
        if (orderMax > 0) {
            this._filter &= this._filterOrdersNumber[orderMax - 1] < this._fullOrdersNumber[orderMax - 1];
        }
        if (this._filter != oldFilter) {
            this.fireTableChanged(new TableModelEvent(this, -1));
        } else {
            this.fireTableChanged(new TableModelEvent(this, 0, this._fullOrdersNumber.length - 1, this._withProbability ? 3 : 2));
            if (this._withProbability) {
                this.fireTableChanged(new TableModelEvent(this, 0, this._fullOrdersNumber.length - 1, 4));
            }
        }
    }

    protected void fireTableChanged(TableModelEvent e) {
        for (TableModelListener listener : this._tableModelListenerList) {
            listener.tableChanged(e);
        }
    }

    private int convertColumnIndex(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                if (!this._withProbability) {
                    return 3;
                }
            }
            case 3: {
                if (this._withProbability) break;
                return 4;
            }
        }
        return columnIndex;
    }

    @Override
    public int getRowCount() {
        return this._fullOrdersNumber.length;
    }

    @Override
    public int getColumnCount() {
        return this._filter ? (this._withProbability ? 5 : 3) : (this._withProbability ? 3 : 2);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                return ResCompute.getString("DLG_RESULT_ORDERS");
            }
            case 1: {
                return ResCompute.getString("DLG_RESULT_CUTS");
            }
            case 2: {
                return ResCompute.getString("DLG_RESULT_PROBAS");
            }
            case 3: {
                return new StringBuffer().append(ResCompute.getString("DLG_RESULT_CUTS")).append(" (").append(ResCompute.getString("DLG_RESULT_FILTER")).append(")").toString();
            }
            case 4: {
                return new StringBuffer().append(ResCompute.getString("DLG_RESULT_PROBAS")).append(" (").append(ResCompute.getString("DLG_RESULT_FILTER")).append(")").toString();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (this.convertColumnIndex(columnIndex)) {
            case 0: {
                if (rowIndex < this._fullOrdersNumber.length - 1) {
                    return rowIndex + 1;
                }
                return ResCompute.getString("DLG_RESULT_TOTAL");
            }
            case 1: {
                return this._fullOrdersNumber[rowIndex];
            }
            case 2: {
                return this._fullOrdersProbability[rowIndex];
            }
            case 3: {
                return this._filterOrdersNumber[rowIndex];
            }
            case 4: {
                return this._filterOrdersProbability[rowIndex];
            }
        }
        return ResMsgVoc.getString("VOC_ERROR");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._tableModelListenerList.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._tableModelListenerList.remove(l);
    }
}

