/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrderRank;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProba;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCSSorterProbaRank
extends MCSSorterProba {
    int _limitRank;
    Cut _limitCut;
    int _addCutCpt;
    int _addCutLimit;
    private static final Logger _LOG = Logger.getLogger(MCSSorterProbaRank.class.getName());
    public static final String PROP_SORTER_PROBA_RANK_DEBUG = "cecilia.ft.compute.mcs.SorterProbaRankXTraTrace";
    private static boolean _FINESTLOG = Boolean.getBoolean("cecilia.ft.compute.mcs.SorterProbaRankXTraTrace") && _LOG.isLoggable(Level.FINEST);

    public MCSSorterProbaRank(int rank) {
        this._limitRank = rank;
        this._limitCut = null;
        this._addCutLimit = Math.max(1000, rank * 2);
        this._addCutCpt = 0;
    }

    protected void mergeResults() {
        if (this._resCuts == null) {
            Cut[] cur2 = new Cut[this._tmpCuts.size()];
            cur2 = this._tmpCuts.toArray(cur2);
            this._resCuts = cur2;
            Arrays.sort(cur2, _comparator);
            int nr = cur2.length;
            if (nr > this._limitRank) {
                nr = this._limitRank;
                Cut[] tmp = new Cut[nr];
                System.arraycopy(cur2, 0, tmp, 0, nr);
                this._resCuts = tmp;
            }
        } else {
            Cut[] cur2 = new Cut[this._tmpCuts.size()];
            cur2 = this._tmpCuts.toArray(cur2);
            Arrays.sort(cur2, _comparator);
            Cut[] cur1 = this._resCuts;
            int nr = cur1.length + cur2.length;
            if (nr > this._limitRank) {
                nr = this._limitRank;
            }
            Cut[] res = new Cut[nr];
            int i1 = 0;
            int i2 = 0;
            int ir = 0;
            while (ir < nr && i1 < cur1.length && i2 < cur2.length) {
                if (_comparator.compare(cur1[i1], cur2[i2]) <= 0) {
                    res[ir++] = cur1[i1++];
                    continue;
                }
                res[ir++] = cur2[i2++];
            }
            while (ir < nr && i1 < cur1.length) {
                res[ir++] = cur1[i1++];
            }
            while (ir < nr && i2 < cur2.length) {
                res[ir++] = cur2[i2++];
            }
            this._resCuts = res;
        }
        this._tmpCuts.clear();
        if (this._resCuts.length > 0) {
            this._limitCut = this._resCuts[this._resCuts.length - 1];
        }
        if (_LOG.isLoggable(Level.FINEST)) {
            _LOG.finest("MergeCuts - lastElement : " + (this._limitCut != null ? this._limitCut.toString() : "<null>"));
        }
        this._addCutCpt = 0;
        this._addCutLimit = this._limitRank;
    }

    @Override
    public void addCut(Cut cut) {
        if (this._limitCut != null && _comparator.compare(this._limitCut, cut) < 0) {
            if (_FINESTLOG) {
                _LOG.finest("~ addCut : " + cut.toString());
            }
            return;
        }
        if (_FINESTLOG) {
            _LOG.finest("  addCut : " + cut.toString());
        }
        super.addCut(cut);
        if (++this._addCutCpt >= this._addCutLimit) {
            this.mergeResults();
        }
    }

    @Override
    protected void finishSorter() {
        this.mergeResults();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MCSSorterOrderRank)) {
            return false;
        }
        MCSSorterProbaRank sorterOrderRank = (MCSSorterProbaRank)obj;
        return sorterOrderRank._limitRank == this._limitRank;
    }

    @Override
    public int hashCode() {
        int hashcode = super.hashCode();
        hashcode = hashcode * 7 + this._limitRank;
        return hashcode;
    }
}

