/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import java.util.ArrayList;
import java.util.List;

public class MCSSortingInOrder
implements MCS {
    int[] _orders;
    List<Cut[]> _cuts;
    int[] _limitRows;
    int[] _limitCuts;
    int _nbrCuts;
    List<MCS.InfoOrder> _infoOrders;

    public MCSSortingInOrder(List<Cut[]> cuts) {
        this._cuts = cuts;
        this.prepare();
    }

    @Override
    public int getOrderMax() {
        return this._infoOrders.size();
    }

    @Override
    public int getOrderNumber(int idx) {
        return this._infoOrders.get(idx).getNumber();
    }

    @Override
    public double getOrderProbability(int idx) {
        return this._infoOrders.get(idx).getProbability();
    }

    public void prepare() {
        int size = this._cuts.size();
        this._infoOrders = new ArrayList<MCS.InfoOrder>(size);
        if (size == 0) {
            this._nbrCuts = 0;
            this._limitRows = new int[1];
            this._limitCuts = new int[1];
            this._limitRows[0] = 0;
            this._limitCuts[0] = 0;
            this._infoOrders.add(new MCS.InfoOrder(0, 1, 1.0));
        } else {
            this._nbrCuts = 0;
            this._limitRows = new int[size];
            this._limitCuts = new int[size];
            int curRank = 0;
            for (int i = 0; i < size; ++i) {
                Cut[] cuts = this._cuts.get(i);
                int nbrCutForOrder_i = cuts.length;
                double proba = 0.0;
                for (int j = 0; j < nbrCutForOrder_i; ++j) {
                    double probaCut = cuts[j].getProbability();
                    if (probaCut < 0.0 || Double.isNaN(probaCut)) {
                        proba = Double.NaN;
                        break;
                    }
                    proba += probaCut;
                }
                this._infoOrders.add(new MCS.InfoOrder(i, nbrCutForOrder_i, proba));
                this._nbrCuts += nbrCutForOrder_i;
                this._limitRows[i] = curRank += nbrCutForOrder_i * i;
                this._limitCuts[i] = this._nbrCuts;
            }
        }
    }

    @Override
    public int getCutCount() {
        return this._nbrCuts;
    }

    @Override
    public MCS.CutIterator cutIterate() {
        class MCSOrderCutIterator
        implements MCS.CutIterator {
            int _idxOrder = 0;
            int _idxCut = -1;

            MCSOrderCutIterator() {
                this.findNext();
            }

            void findNext() {
                ++this._idxCut;
                while (this._idxOrder < MCSSortingInOrder.this._cuts.size()) {
                    Cut[] cuts = MCSSortingInOrder.this._cuts.get(this._idxOrder);
                    if (this._idxCut < cuts.length) {
                        return;
                    }
                    ++this._idxOrder;
                    this._idxCut = 0;
                }
            }

            @Override
            public boolean hasNext() {
                return this._idxOrder < MCSSortingInOrder.this._cuts.size();
            }

            @Override
            public Cut next() {
                Cut current = MCSSortingInOrder.this._cuts.get(this._idxOrder)[this._idxCut];
                this.findNext();
                return current;
            }
        }
        return new MCSOrderCutIterator();
    }

    public Cut getCut(int cut) {
        int idxOrder;
        for (idxOrder = 0; idxOrder < this._orders.length && cut >= this._orders[idxOrder]; cut -= this._orders[idxOrder], ++idxOrder) {
        }
        return this._cuts.get(idxOrder)[cut];
    }

    @Override
    public int getRowCount() {
        return this._limitRows[this._limitRows.length - 1];
    }

    @Override
    public Cut getRowCut(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            if ((row - this._limitRows[i]) % (i + 1) == 0) {
                return this._cuts.get(i + 1)[(row - this._limitRows[i]) / (i + 1)];
            }
            return null;
        }
        return null;
    }

    @Override
    public int getRowIndexCut(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            return this._limitCuts[i] + (row - this._limitRows[i]) / (i + 1);
        }
        return -1;
    }

    @Override
    public Evt getRowEvent(int row) {
        for (int i = this._limitRows.length - 1; i >= 0; --i) {
            if (this._limitRows[i] > row) continue;
            Cut cut = this._cuts.get(i + 1)[(row - this._limitRows[i]) / (i + 1)];
            return cut.getEvent((row - this._limitRows[i]) % (i + 1));
        }
        return null;
    }
}

