/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTablePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MCSTablePanelWithInfo
extends JPanel {
    MCSTablePanel _mcsTable;
    JLabel _filterQ;
    int _fullCutCount;

    public MCSTablePanelWithInfo(MCS mcs, ArborRenderer renderer, boolean withProbability, Map<Attr.Key, Set<String>> attributes) {
        super(new GridBagLayout());
        this.create(mcs, renderer, withProbability, attributes);
    }

    private void create(MCS mcs, ArborRenderer renderer, boolean withProbability, Map<Attr.Key, Set<String>> attributes) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this._mcsTable = new MCSTablePanel(mcs, renderer, withProbability, attributes);
        this._fullCutCount = mcs.getCutCount();
        this.add((Component)this._mcsTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        this._filterQ = new JLabel(ResMsgCore.msgFormat("MSG_X_ON_Y", this._fullCutCount, this._fullCutCount));
        this._filterQ.setHorizontalAlignment(4);
        this._mcsTable.addFilterListener(new MCSTablePanel.MCSFilterListener(){

            @Override
            public void changeTable(MCS mcsDisplay, MCSFilter filter) {
                MCSTablePanelWithInfo.this._filterQ.setText(ResMsgCore.msgFormat("MSG_X_ON_Y", mcsDisplay.getCutCount(), MCSTablePanelWithInfo.this._fullCutCount));
                if (filter == null) {
                    MCSTablePanelWithInfo.this._filterQ.setToolTipText("");
                } else {
                    MCSTablePanelWithInfo.this._filterQ.setToolTipText(filter.getAbstract());
                }
            }
        });
        this.add((Component)this._filterQ, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 10, 10), 0, 0));
    }
}

