/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TaskContainer
implements Runnable {
    private static Logger _LOG = Logger.getLogger(TaskContainer.class.getPackage().getName());
    List<TaskItem> _items = new ArrayList<TaskItem>();
    List<Runnable> _finallies = new ArrayList<Runnable>();
    static final boolean __WAIT = false;
    boolean _requestStop;
    boolean _requestSuspend;
    boolean _finnished;
    Object _requestSuspendLocker = new Object();
    int _curAction = -1;
    int _maxAction;
    int _curStep;
    int _maxStep;
    TaskItem _curItem;

    public void addError(String msg) {
        _LOG.log(Level.SEVERE, msg);
    }

    public void addWarning(String msg) {
        _LOG.log(Level.WARNING, msg);
    }

    public void addItem(TaskItem item) {
        this._items.add(item);
    }

    public void addFinally(Runnable runnable) {
        this._finallies.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._finnished = false;
        this._requestStop = false;
        this._requestSuspend = false;
        this._curAction = 0;
        this._curStep = 0;
        this._maxAction = this._items.size();
        this._maxStep = 0;
        for (int i = 0; i < this._items.size(); ++i) {
            this._maxStep += this._items.get(i).getMaxStep();
        }
        try {
            _LOG.finer("TaskContainer started");
            while (this._curAction < this._maxAction) {
                this._curItem = this._items.get(this._curAction++);
                _LOG.finer("TaskContainer beginning item : " + this._curItem.getInfo());
                this._curItem.run();
                if (!this._curItem.continueWhenFinnished() || this._requestStop) break;
                if (this._requestSuspend) {
                    try {
                        _LOG.fine("TaskContainer request suspend");
                        Object i = this._requestSuspendLocker;
                        synchronized (i) {
                            this._requestSuspendLocker.wait();
                        }
                        _LOG.fine("TaskContainer request resume");
                    }
                    catch (InterruptedException e) {
                        _LOG.log(Level.INFO, "InterruptedException", e);
                        break;
                    }
                }
                if (this._requestStop) break;
                this._curStep += this._curItem.getMaxStep();
            }
            this._finnished = true;
            _LOG.finer("TaskContainer finalized");
        }
        catch (Throwable t) {
            _LOG.log(Level.WARNING, "During runnable TaskContainer : ", t);
            this._finnished = true;
        }
        finally {
            for (int i = 0; i < this._finallies.size(); ++i) {
                try {
                    this._finallies.get(i).run();
                    continue;
                }
                catch (Throwable t) {
                    _LOG.log(Level.WARNING, "During finally TaskContainer : ", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStop() {
        this._requestStop = true;
        this._curItem.requestStop();
        if (this._requestSuspend) {
            this._requestSuspend = false;
            Object object = this._requestSuspendLocker;
            synchronized (object) {
                this._requestSuspendLocker.notifyAll();
            }
        }
    }

    public void requestSuspend() {
        this._requestSuspend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestResume() {
        this._requestSuspend = false;
        Object object = this._requestSuspendLocker;
        synchronized (object) {
            this._requestSuspendLocker.notifyAll();
        }
    }

    public String getInfo() {
        if (this._finnished) {
            if (this._requestStop) {
                return ResCompute.getString("TASK_INFO_CANCEL");
            }
            return ResCompute.getString("TASK_INFO_FINNISH");
        }
        if (this._curAction < 0) {
            return ResCompute.getString("TASK_INFO_NOSTART");
        }
        if (this._curItem != null) {
            return this._curItem.getInfo();
        }
        return "???";
    }

    protected float getProgress() {
        if (this._finnished) {
            return 1.0f;
        }
        if (this._curAction < 0) {
            return -1.0f;
        }
        if (this._curAction == 0) {
            return 0.0f;
        }
        if (this._curStep <= this._maxStep && this._curItem != null) {
            return (float)(this._curStep + this._curItem.getCurStep()) / (float)this._maxStep;
        }
        return 1.0f;
    }

    public PlugTask createPlugTask(final String taskName, final String taskDesc, final ImageIcon taskIcon) {
        return new PlugTask(){

            @Override
            public void run() {
                TaskContainer.this.run();
            }

            @Override
            public void requestStop() {
                TaskContainer.this.requestStop();
            }

            @Override
            public void requestSuspend(boolean high) {
                TaskContainer.this.requestSuspend();
            }

            @Override
            public void requestResume() {
                TaskContainer.this.requestResume();
            }

            @Override
            public String getInfo(String key) {
                if (key.equals("process.msg")) {
                    return TaskContainer.this.getInfo();
                }
                if (key.equals("process.p1000")) {
                    return Integer.toString((int)(TaskContainer.this.getProgress() * 1000.0f));
                }
                if (key.equals("ptask.desc")) {
                    return taskDesc;
                }
                if (key.equals("plugin.name")) {
                    return taskName;
                }
                return null;
            }

            @Override
            public boolean isPriority() {
                return false;
            }

            @Override
            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return taskIcon;
                }
                return null;
            }
        };
    }
}

