/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineControlLog;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIEngineExecute
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIEngineExecute.class.getPackage().getName());
    EngineExecute _engineExecute;
    EngineBDDConfig.ResultType _result;
    boolean _requestStop = false;

    public TaskIEngineExecute(TaskContainer container, EngineExecute engine) {
        super(container);
        this._engineExecute = engine;
    }

    @Override
    public void run() {
        final StringBuffer userBuffer = new StringBuffer();
        EngineControlLog ctrl = new EngineControlLog(){

            @Override
            public boolean isCanceled() {
                return TaskIEngineExecute.this._requestStop;
            }

            @Override
            public void appendUserMsg(String msg) {
                if (!userBuffer.isEmpty()) {
                    userBuffer.append("\n");
                }
                userBuffer.append(msg);
            }
        };
        this._result = this._engineExecute.execute(ctrl);
        if (this._result == EngineBDDConfig.ResultType.NoError) {
            _LOG.log(Level.FINE, "EngineBDD : Compute ok");
        } else if (ctrl.isCanceled()) {
            _LOG.log(Level.FINE, "EngineBDD : Compute cancel");
        } else {
            this.addError(ResCompute.getString("MSG_ENGINE_ERR_HEADER") + userBuffer);
            _LOG.log(Level.INFO, "EngineBDD : Compute ko");
        }
    }

    public String getMsgInfo() {
        return ResCompute.getString("TASK_INFO_ENGINE_LAUNCH");
    }

    @Override
    public String getInfo() {
        if (this.getMaxStep() > 1) {
            StringBuffer sb = new StringBuffer(256);
            sb.append(this.getCurStep()).append("/").append(this.getMaxStep()).append(" : ");
            sb.append(this.getMsgInfo());
            return sb.toString();
        }
        return this.getMsgInfo();
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return this._result == EngineBDDConfig.ResultType.NoError;
    }

    @Override
    protected int getCurStep() {
        return this._engineExecute.getCurStep();
    }

    @Override
    protected int getMaxStep() {
        return this._engineExecute.getMaxStep();
    }
}

