/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttribute;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanExpression;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.util.LinkedHashSet;

public class TaskIResultCriticity
extends TaskItem {
    private final AttrCriterion _attrCriterion;
    private final BooleanResult _result;

    public TaskIResultCriticity(TaskContainer container, BooleanResult result, ParamComputeAbstract parameter) {
        super(container);
        this._attrCriterion = parameter.getCriteriumLSR();
        this._result = result;
    }

    @Override
    public void run() {
        CriticityResult info = TaskIResultCriticity.getCriticityInfo(this._result, this._attrCriterion);
        this._result.setCriticityResult(info);
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_CRITICITY");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return true;
    }

    public static final CriticityResult getCriticityInfo(BooleanResult boolResult, AttrCriterion attrCriterion) {
        boolean noComputationOnLatentLSR;
        BooleanMCS mcsResult = boolResult.getMCS();
        CriticityResult info = new CriticityResult();
        if (attrCriterion != null) {
            info.setAttributeCriterion(attrCriterion.toString());
        }
        String probaCrit = boolResult.getStore().getInfo(BooleanStore.INFO_CRITICITY_PROBA);
        String orderCrit = boolResult.getStore().getInfo(BooleanStore.INFO_CRITICITY_ORDER);
        String evidentLSR = boolResult.getStore().getInfo(BooleanStore.INFO_CRITICITY_LSR_EVIDENT);
        String latentLSR = boolResult.getStore().getInfo(BooleanStore.INFO_CRITICITY_LSR_LATENT);
        if (probaCrit != null && !probaCrit.isEmpty()) {
            double probaCritVal = Double.valueOf(probaCrit);
            info.setProbRespected(probaCritVal > boolResult.getRootProbability());
            info.setProbValue(boolResult.getRootProbability());
        }
        if (orderCrit != null && !orderCrit.isEmpty()) {
            int orderCritVal = Integer.valueOf(orderCrit);
            if (mcsResult.getCutCount() != 0) {
                int orderFirstCut = mcsResult.getCut(0).getOrder();
                info.setOrderCritRespected(orderFirstCut > orderCritVal);
                info.setOrderValue(orderFirstCut);
            } else {
                info.setOrderCritRespected(false);
                info.setOrderValue(-1);
            }
        }
        boolean noComputationOnEvidentLSR = evidentLSR == null || evidentLSR.isEmpty() || Double.isNaN(Double.valueOf(evidentLSR));
        boolean bl = noComputationOnLatentLSR = latentLSR == null || latentLSR.isEmpty() || Double.isNaN(Double.valueOf(latentLSR));
        if (noComputationOnEvidentLSR && noComputationOnLatentLSR) {
            return info;
        }
        if (attrCriterion == null) {
            if (!noComputationOnEvidentLSR) {
                info.setEvidentLSRRespected(false);
                info.setEvidentLSRCutMsg(ResCompute.getString("DLG_RESULT_CRITICITY_TABLE_NO_LATENT_ATTRIBUTE"));
            }
            if (!noComputationOnLatentLSR) {
                info.setLatentLSRRespected(false);
                info.setLatentLSRCutMsg(ResCompute.getString("DLG_RESULT_CRITICITY_TABLE_NO_LATENT_ATTRIBUTE"));
            }
            return info;
        }
        Double evidentLSRVal = null;
        if (!noComputationOnEvidentLSR) {
            evidentLSRVal = Double.valueOf(evidentLSR);
        } else {
            info.setEvidentLSRRespected(null);
            info.setEvidentLSRCutMsg(String.valueOf(Double.NaN));
        }
        Double latentLSRVal = null;
        if (!noComputationOnLatentLSR) {
            latentLSRVal = Double.valueOf(latentLSR);
        } else {
            info.setLatentLSRRespected(null);
            info.setLatentLSRCutMsg(String.valueOf(Double.NaN));
        }
        LinkedHashSet<Cut> cutsRespectingLSR = new LinkedHashSet<Cut>();
        for (int i = 0; i < mcsResult.getCutCount(); ++i) {
            Cut cut = mcsResult.getCut(i);
            boolean withError = false;
            boolean withEvident = false;
            boolean withLatent = false;
            for (int j = 0; j < cut.getOrder() && !withError; ++j) {
                Evt event = cut.getEvent(j);
                Attr neededAttribute = null;
                for (Attr attr : event.getAttributs()) {
                    if (!attrCriterion.match(attr)) continue;
                    neededAttribute = attr;
                    break;
                }
                if (neededAttribute == null || !attrCriterion.match(neededAttribute)) {
                    if (!withEvident) {
                        withEvident = true;
                        continue;
                    }
                    withError = true;
                    continue;
                }
                if (neededAttribute == null || !attrCriterion.match(neededAttribute)) continue;
                withLatent = true;
            }
            if (withError || !withEvident || !withLatent) continue;
            cutsRespectingLSR.add(cut);
        }
        if (cutsRespectingLSR.isEmpty()) {
            if (!noComputationOnEvidentLSR) {
                info.setEvidentLSRRespected(false);
                info.setEvidentLSRCutMsg(ResCompute.getString("DLG_RESULT_CRITICITY_TABLE_NO_CUTS_EVIDENT"));
            }
            if (!noComputationOnLatentLSR) {
                info.setLatentLSRRespected(false);
                info.setLatentLSRCutMsg(ResCompute.getString("DLG_RESULT_CRITICITY_TABLE_NO_CUTS_LATENT"));
            }
        } else {
            if (!noComputationOnEvidentLSR) {
                info.setEvidentLSRRespected(evidentLSRVal != null);
            }
            if (!noComputationOnLatentLSR) {
                info.setLatentLSRRespected(latentLSRVal != null);
            }
            for (Cut cut : cutsRespectingLSR) {
                if (!(info.getEvidentLSRRespected() != null && info.getEvidentLSRRespected() != false || info.getLatentLSRRespected() != null && info.getLatentLSRRespected() != false)) break;
                int orderCut = cut.getOrder();
                LinkedHashSet<Evt> evtsLatent = new LinkedHashSet<Evt>();
                for (int i = 0; i < orderCut && (info.getEvidentLSRRespected() != null && info.getEvidentLSRRespected().booleanValue() || info.getLatentLSRRespected() != null && info.getLatentLSRRespected().booleanValue()); ++i) {
                    Evt evt = cut.getEvent(i);
                    Attr attr = null;
                    for (Attr attr2 : evt.getAttributs()) {
                        if (!attrCriterion.match(attr2)) continue;
                        attr = attr2;
                        break;
                    }
                    if (attr != null && attrCriterion.match(attr) && latentLSRVal != null && info.getLatentLSRRespected() != null) {
                        evtsLatent.add(evt);
                        continue;
                    }
                    if (evidentLSRVal == null || info.getEvidentLSRRespected() == null) continue;
                    boolean evidentOK = evt.getProbability() < evidentLSRVal;
                    info.setEvidentLSRRespected(info.getEvidentLSRRespected() != false && evidentOK);
                    if (evidentOK) continue;
                    info.setEvidentLSRCutMsg("Event " + evt + " (" + evt.getProbability() + ")");
                }
                if (noComputationOnLatentLSR) continue;
                double proba = 1.0;
                for (Evt eventLatent : evtsLatent) {
                    BooleanAttribute booleanAttribute = ((BooleanNode)eventLatent).getAttribute(BooleanAttribute.KEY_INSPECTED);
                    if (booleanAttribute == null) {
                        info.setLatentLSRCutMsg("Inspected : " + eventLatent.getName());
                        break;
                    }
                    proba *= eventLatent.getProbability() * ((BooleanExpression.ParameterFloat)booleanAttribute.getValue()).getValue(0.0);
                }
                boolean latentOK = proba < latentLSRVal;
                info.setLatentLSRRespected(info.getLatentLSRRespected() != false && latentOK);
                if (latentOK || info.getLatentLSRCutError() != null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("Event ");
                sb.append(evtsLatent.size() < 2 ? "" : Character.valueOf('{'));
                for (Evt evt : evtsLatent) {
                    sb.append(evt.getName()).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append(evtsLatent.size() < 2 ? "" : Character.valueOf('}'));
                sb.append(" (");
                sb.append(proba);
                sb.append(")");
                info.setLatentLSRCutMsg(sb.toString());
            }
        }
        if (info.getEvidentLSRRespected() != null && info.getEvidentLSRRespected().booleanValue()) {
            info.setEvidentLSRCutMsg(CriticityResult.OKKO.OK.name());
        }
        if (info.getLatentLSRRespected() != null && info.getLatentLSRRespected().booleanValue()) {
            info.setLatentLSRCutMsg(CriticityResult.OKKO.OK.name());
        }
        return info;
    }
}

