/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborPreferenciesRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MELPanel;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import javax.swing.Icon;

public class TaskIResultDisplayMEL
extends TaskItem {
    ComputeMELAbstract _compute;
    Plugable _plugable;
    InfoDatum _idatum;
    boolean _simple = false;

    public TaskIResultDisplayMEL(TaskContainer container, ComputeMELAbstract compute, Plugable plugable, InfoDatum idatum) {
        super(container);
        this._compute = compute;
        this._plugable = plugable;
        this._idatum = idatum;
    }

    public TaskIResultDisplayMEL(TaskContainer container, ComputeMELAbstract compute, Plugable plugable, InfoDatum idatum, boolean simple) {
        this(container, compute, plugable, idatum);
        this._simple = simple;
    }

    @Override
    public void run() {
        BooleanMEL.Item nominal = this._compute.getResults().getNominalItem();
        if (nominal.isAlwaysTrue() || nominal.isAlwaysFalse()) {
            this.addError(ResCompute.getString("MEL_TARGET_NOMINAL") + "\n" + nominal.getWarning());
        } else {
            this._compute.getResults().sortItems();
            MELPanel plugPanel = null;
            plugPanel = !this._simple ? new MELPanel(this._compute, this._plugable, this._idatum, new ArborPreferenciesRenderer(this._plugable)) : new MELPanel(this._compute, this._plugable, this._idatum, new ArborPreferenciesRenderer(this._plugable)){

                @Override
                public Icon getIcon(String key) {
                    if (key.equals("ppanel.icon")) {
                        return ResIcoCompute.getImageIcon("PLUGIN_DEBUG");
                    }
                    return super.getIcon(key);
                }

                @Override
                protected String getTitleHeader() {
                    return ResCompute.getString("PLUG_CMD_MEL2_NAME");
                }

                @Override
                protected String getFileExtention() {
                    return ".mel2";
                }
            };
            this._plugable.addPanel(plugPanel, this._idatum.getModel().getUID());
        }
        this._compute.setEndOfAction(true);
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_DISPLAY");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return true;
    }
}

