/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIResultLoadMEL
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultLoadMEL.class.getPackage().getName());
    ComputeMEL _compute;
    InfoDatum _idatum;
    boolean _withError;
    boolean _requestStop = false;

    public TaskIResultLoadMEL(TaskContainer container, ComputeMEL compute, InfoDatum idatum) {
        super(container);
        this._compute = compute;
        this._idatum = idatum;
        this._withError = false;
    }

    public static boolean loadMEL(File file, BooleanStore store, BooleanMEL results) {
        return TaskIResultLoadMEL.loadMELWithError(file, store, results) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadMELWithError(File file, BooleanStore store, BooleanMEL results) {
        FilterInputStream inStream = null;
        try {
            inStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int format = -1;
            format = ((DataInputStream)inStream).readInt();
            if (format < 1 || format > 3) {
                throw new IOException("Incompatible data format [format = " + format + "]");
            }
            if (format >= 3) {
                boolean simplified = ((DataInputStream)inStream).readBoolean();
                results.setSimplified(simplified);
            }
            boolean withProba = ((DataInputStream)inStream).readBoolean();
            int nbrTargets = ((DataInputStream)inStream).readInt();
            int nbrOrders = ((DataInputStream)inStream).readInt();
            BooleanMEL.ModifiableItem item = results.createItem(null, nbrOrders + 1);
            TaskIResultLoadMEL.loadItem((DataInputStream)inStream, format, item, nbrOrders, withProba);
            for (int i = 0; i < nbrTargets; ++i) {
                int idx = ((DataInputStream)inStream).readInt();
                BooleanNode node = store.getLeaf(idx);
                String name = ((DataInputStream)inStream).readUTF();
                BooleanNode leaf = store.getLeaf(idx);
                if (!leaf.getName().equals(name)) {
                    throw new IOException("Incompatible store/result [leaf '" + name + "," + idx + "']");
                }
                BooleanMEL.ModifiableItem item2 = results.createItem(node, nbrOrders + 1);
                TaskIResultLoadMEL.loadItem((DataInputStream)inStream, format, item2, nbrOrders, withProba);
            }
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during load 'mel file'", e);
            String string = e.getMessage();
            return string;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'mel file'", e);
                    return "Error during close 'mel file'";
                }
            }
        }
        return null;
    }

    private static void loadItem(DataInputStream inStream, int format, BooleanMEL.ModifiableItem item, int nbrOrders, boolean withProba) throws IOException {
        int j;
        boolean bWarning;
        item.setAlwaysTrue(inStream.readBoolean());
        item.setAlwaysFalse(inStream.readBoolean());
        if (format >= 2 && (bWarning = inStream.readBoolean())) {
            item.setWarning(inStream.readUTF());
        }
        for (j = 0; j <= nbrOrders; ++j) {
            item.setOrderNumber(j, inStream.readLong());
        }
        if (withProba) {
            item.setProbability(inStream.readDouble());
            for (j = 0; j <= nbrOrders; ++j) {
                item.setOrderProbability(j, inStream.readDouble());
            }
        }
    }

    @Override
    public void run() {
        File file;
        if (!this._withError && !TaskIResultLoadMEL.loadMEL(file = this._idatum.getInputFiles().get("result.mel"), this._compute.getStore(), this._compute.getResults())) {
            this._withError = true;
        }
        if (this._withError) {
            this.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_LOAD");
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._withError;
    }
}

