/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderHelper;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIResultParser
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultParser.class.getPackage().getName());
    BooleanResult _boolResult;
    File _resFile;
    boolean _error;
    boolean _requestStop = false;

    public TaskIResultParser(TaskContainer container, BooleanResult result, File resFile) {
        super(container);
        this._boolResult = result;
        this._resFile = resFile;
        this._error = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._error = true;
        BooleanNode root = this._boolResult.getStore().getRoot();
        if (root == null) {
            _LOG.log(Level.SEVERE, "No root for current store !!");
            return;
        }
        Reader resReader = null;
        try {
            resReader = new BufferedReader(new FileReader(this._resFile));
            MCSReaderHelper helper = new MCSReaderHelper(){

                @Override
                public boolean isCanceled() {
                    return TaskIResultParser.this._requestStop;
                }
            };
            this._boolResult.parse(root, resReader, helper);
            if (_LOG.isLoggable(Level.FINER)) {
                _LOG.finer("Abstract MCS resultat (juste after read): " + this._boolResult.getResultAbstract());
            }
            if (helper.hasLimited() && !this._boolResult.getMCS().isAlwaysTrue() && !this._boolResult.getMCS().isAlwaysFalse()) {
                this.addError(helper.getWarningMsg());
            }
            this._error = false;
        }
        catch (IOException e) {
            this.addError(ResCompute.getString("MSG_RESULT_ERR_READ"));
            _LOG.log(Level.WARNING, "IOException during read result" + e.getMessage(), e);
            return;
        }
        finally {
            if (resReader != null) {
                try {
                    resReader.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.FINEST, "IOException during close stream result", e);
                }
            }
            if (!this._resFile.delete()) {
                this._resFile.deleteOnExit();
            }
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_READ");
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

