/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.MCSOutputStream;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrder;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterOrderRank;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProba;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSSorterProbaRank;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveAbstract;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIResultSaveMCS
extends TaskIResultSaveAbstract {
    private static Logger _LOG = Logger.getLogger(TaskIResultSaveMCS.class.getPackage().getName());
    InfoDatum _idatum;
    Plugable _plugable;
    private static final int PROP_MCS_ABSTRACT_CUTSMAX_DEF = 100;
    public static final String PROP_MCS_ABSTRACT_CUTSMAX = "cecilia.ft.compute.mcs.AbstractCutsMax";

    public TaskIResultSaveMCS(TaskContainer container, ComputeMCS compute, InfoDatum idatum, Plugable plugable) {
        super(container, compute);
        this._idatum = idatum;
        this._plugable = plugable;
    }

    @Override
    protected ComputeMCS getCompute() {
        return (ComputeMCS)super.getCompute();
    }

    protected static void appendProbabilities(Writer writer, String indent, BooleanStore store, BooleanResult results) throws IOException {
        int nbrLeaves = store.getNbrLeaves();
        for (int i = 0; i < nbrLeaves; ++i) {
            BooleanNode leaf = store.getLeaf(i);
            int idx = leaf.getIndex();
            writer.append(indent).append("<ftc.probability");
            writer.append(" id='e").append(Integer.toString(idx)).append("'");
            writer.append(" name='").append(XMLWriter.toXML((String)leaf.getName())).append("'");
            writer.append(" pr='").append(Double.toString(leaf.getProbability())).append("'");
            Map<ParamCompute.TypeImportanceFactor, double[]> mapImpF = results.getLeavesImportanceFactors();
            if (!mapImpF.isEmpty()) {
                for (Map.Entry<ParamCompute.TypeImportanceFactor, double[]> IF2 : mapImpF.entrySet()) {
                    writer.append(" ").append(IF2.getKey().toString().toLowerCase()).append("='").append(Double.toString(IF2.getValue()[idx])).append("'");
                }
            }
            writer.append("/>\n");
        }
        double[] gatesPr = results.getGatesProbability();
        if (gatesPr == null) {
            BooleanNode root = store.getRoot();
            writer.append(indent).append("<ftc.probability");
            writer.append(" id='g").append(Integer.toString(root.getIndex())).append("'");
            writer.append(" name='").append(XMLWriter.toXML((String)root.getName())).append("'");
            writer.append(" pr='").append(Double.toString(results.getRootProbability())).append("'");
            writer.append("/>\n");
        } else {
            int nbrGates = store.getNbrGates();
            for (int i = 0; i < nbrGates; ++i) {
                BooleanNode gate = store.getGate(i);
                int idx = gate.getIndex();
                writer.append(indent).append("<ftc.probability");
                writer.append(" id='g").append(Integer.toString(idx)).append("'");
                writer.append(" name='").append(XMLWriter.toXML((String)gate.getName())).append("'");
                writer.append(" pr='").append(Double.toString(gatesPr[idx])).append("'");
                writer.append("/>\n");
            }
        }
    }

    protected static void appendMCSAbstract(Writer writer, String indent, BooleanStore store, BooleanResult results, ParamComputeAbstract parameters) throws IOException {
        boolean withProbability = parameters.getTypeProbability() != TypeProbability.NONE;
        writer.append(indent).append("<ftc.mcs.abstract").append(">\n");
        BooleanMCS fullMCS = results.getMCS();
        int orderMax = fullMCS.getOrderMax();
        for (int i = 1; i < orderMax; ++i) {
            if (fullMCS.getOrderNumber(i) == 0) continue;
            writer.append(indent).append("  <ftc.mcs.order");
            writer.append(" order='").append(Integer.toString(i)).append("'");
            writer.append(" nbr='").append(Integer.toString(fullMCS.getOrderNumber(i))).append("'");
            if (withProbability) {
                writer.append(" pr='").append(Double.toString(fullMCS.getOrderProbability(i))).append("'");
            }
            writer.append("/>\n");
        }
        int limitRank = Integer.getInteger(PROP_MCS_ABSTRACT_CUTSMAX, 100);
        MCS sorterMCS = null;
        if (limitRank > 0) {
            MCSSorter sorter = null;
            sorter = fullMCS.getCutCount() <= limitRank ? (withProbability ? new MCSSorterProba() : new MCSSorterOrder(false)) : (withProbability ? new MCSSorterProbaRank(limitRank) : new MCSSorterOrderRank(false, limitRank));
            MCS.CutIterator iter = fullMCS.cutIterate();
            while (iter.hasNext()) {
                sorter.addCut(iter.next());
            }
            sorterMCS = sorter.getMCS();
        }
        if (sorterMCS != null) {
            MCS.CutIterator iter = sorterMCS.cutIterate();
            while (iter.hasNext()) {
                Cut cut = iter.next();
                writer.append(indent).append("  <ftc.mcs.cut");
                if (withProbability) {
                    writer.append(" pr='").append(Double.toString(cut.getProbability())).append("'");
                }
                writer.append(" evts='");
                for (int j = 0; j < cut.getOrder(); ++j) {
                    if (j > 0) {
                        writer.append(" ");
                    }
                    writer.append(Integer.toString(cut.getEvent(j).getIndex()));
                }
                writer.append("' />\n");
            }
        }
        writer.append(indent).append("</ftc.mcs.abstract").append(">\n");
    }

    public static void appendCriticity(Writer writer, String indent, BooleanResult results, ParamComputeAbstract parameters) throws IOException {
        CriticityResult info = results.getCriticityResult();
        if (info == null || !info.isAComputeCriticity()) {
            return;
        }
        info.writeCriticityAbstract(writer, indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveAbstract(BooleanStore store, BooleanResult results, ParamComputeAbstract parameters) {
        File file = null;
        try {
            file = File.createTempFile("FTResultAbstract", ".xml");
            file.deleteOnExit();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during create 'probabilities file'", e);
            return null;
        }
        boolean bSuccess = false;
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.append("<?xml version='1.0' encoding='iso-8859-15'?>\n");
            writer.append("<ftc version='1'>\n");
            TaskIResultSaveMCS.appendParameters(writer, "  ", store, parameters);
            TaskIResultSaveMCS.appendWarnings(writer, "  ", store, results);
            TaskIResultSaveMCS.appendProbabilities(writer, "  ", store, results);
            TaskIResultSaveMCS.appendMCSAbstract(writer, "  ", store, results, parameters);
            TaskIResultSaveMCS.appendCriticity(writer, "  ", results, parameters);
            writer.append("</ftc>\n");
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'parameters file'", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'parameters file'", e);
                }
            }
        }
        if (!bSuccess && file.exists()) {
            file.delete();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveCuts(BooleanStore store, BooleanResult results) {
        File file = null;
        try {
            file = File.createTempFile("BCuts", ".bin");
            file.deleteOnExit();
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during create 'cuts file'", e);
            return null;
        }
        boolean bSuccess = false;
        FilterOutputStream outStream = null;
        try {
            int nbrLeaves = store.getNbrLeaves();
            BooleanMCS mcs = results.getMCS();
            outStream = new MCSOutputStream(new BufferedOutputStream(new FileOutputStream(file)), nbrLeaves + 2);
            outStream.write(1);
            ((MCSOutputStream)outStream).writeInt(mcs.getCutCount());
            MCS.CutIterator iter = mcs.cutIterate();
            while (iter.hasNext()) {
                Cut cut = iter.next();
                int order = cut.getOrder();
                ((MCSOutputStream)outStream).writeIndex(order);
                for (int i = 0; i < order; ++i) {
                    ((MCSOutputStream)outStream).writeIndex(cut.getEvent(i).getIndex());
                }
            }
            ((MCSOutputStream)outStream).flush();
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'cuts file'", e);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'cuts file'", e);
                }
            }
        }
        if (!bSuccess && file.exists()) {
            file.delete();
        } else {
            _LOG.finest("Save cuts > " + file.toString());
        }
        return file;
    }

    @Override
    public void run() {
        File cutsFile = TaskIResultSaveMCS.saveCuts(this.getCompute().getStore(), this.getCompute().getResults());
        if (cutsFile == null) {
            return;
        }
        File abstractFile = TaskIResultSaveMCS.saveAbstract(this.getCompute().getStore(), this.getCompute().getResults(), this.getCompute().getParameters());
        if (abstractFile == null) {
            return;
        }
        String key = this._idatum.getKey();
        _LOG.info("SaveMCS : key='" + key + "' cutsFile='" + cutsFile + "' abstractFile='" + abstractFile + "'");
        if (!key.endsWith(".Abstract")) {
            this._idatum.setKey(key + ".Abstract");
        }
        this._idatum.getInputFiles().put("result.abstract", abstractFile);
        this._idatum.getParameters().put("result.save", "true");
        this._idatum.getInputFiles().remove("result.cuts");
        this._plugable.setDatum(this._idatum, this._plugable);
        if (!key.endsWith(".Abstract")) {
            this._idatum.setKey(key);
        } else {
            this._idatum.setKey(key.substring(0, key.length() - ".Abstract".length()));
        }
        this._idatum.getInputFiles().put("result.cuts", cutsFile);
        this._plugable.setDatum(this._idatum, this._plugable);
    }

    @Override
    public String getInfo() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.getInfo()).append(" [");
        buffer.append(ResCompute.getString("PLUG_CMD_NOMINAL_ABREV"));
        buffer.append("]");
        return buffer.toString();
    }
}

