/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ProbabilityVerify;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.File;

public class TaskIStorePrepare
extends TaskItem {
    BooleanStore _store;
    ParamCompute _parameters;
    File _xmlFile;
    boolean _error;

    public TaskIStorePrepare(TaskContainer container, BooleanStore store, ParamCompute parameters) {
        super(container);
        this._store = store;
        this._parameters = parameters;
        this._error = false;
    }

    @Override
    public void run() {
        String msg;
        if (this._parameters.getTypeProbability() == TypeProbability.NONE) {
            return;
        }
        double missionTime = this._parameters.getMissionTimeH();
        if (missionTime < 0.0) {
            return;
        }
        ProbabilityVerify ctrl = new ProbabilityVerify();
        this._store.computeLeavesProbability(missionTime, ctrl);
        if (!ctrl.withError()) {
            this._store.prepareComputeAverageRisk(this._parameters.getTypeProbability(), missionTime, ctrl);
        }
        if ((msg = ctrl.getMessage()) != null) {
            this._error = ctrl.withError();
            if (this._error) {
                this.addError(msg);
            } else {
                this._store.addWarning(msg);
                this.addWarning(msg);
            }
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_STORE_PREPARE");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

