/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JOptionPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DesktopParameters {
    public static final int OPEN = 1;
    public static final int PRINT = 2;
    public static final int WEB = 3;
    public static final int MAIL = 4;
    int _type = 1;
    String _arg;
    public static final String KEY_DEFAULT = "desktop-argument";
    protected static IOParameters _instance = new IOParameters(){

        @Override
        public Object readXML(Node node, PluginManager launcher) {
            if (node.getNodeType() != 1) {
                return null;
            }
            Element root = (Element)node;
            if (!root.getNodeName().equals(DesktopParameters.KEY_DEFAULT)) {
                return null;
            }
            String txt = root.getTextContent();
            return new DesktopParameters(1, DefaultIOParameters.fromXML(txt));
        }

        @Override
        public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
            DesktopParameters param = (DesktopParameters)parameters;
            out.write("<");
            out.write(DesktopParameters.KEY_DEFAULT);
            out.write(" action='");
            out.write(Integer.toString(param.getType()));
            out.write("'>");
            out.write(DefaultIOParameters.toXML(param.getArgument()));
            out.write("</");
            out.write(DesktopParameters.KEY_DEFAULT);
            out.write(">");
        }
    };

    public int getType() {
        return this._type;
    }

    public String getArgument() {
        return this._arg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        switch (this._type) {
            case 1: {
                sb.append(ResTreatment.getString("DESKTOP_LBL_OPEN"));
                break;
            }
            case 2: {
                sb.append(ResTreatment.getString("DESKTOP_LBL_PRINT"));
                break;
            }
            case 3: {
                sb.append(ResTreatment.getString("DESKTOP_LBL_WEB"));
                break;
            }
            case 4: {
                sb.append(ResTreatment.getString("DESKTOP_LBL_MAIL"));
            }
        }
        sb.append(" : ").append(this._arg).append("\n");
        return sb.toString();
    }

    public DesktopParameters() {
        this._type = 1;
        this._arg = "%{file}";
    }

    public DesktopParameters(int type, String arg) {
        this._type = type;
        this._arg = arg;
    }

    public DesktopParameters(DesktopParameters src) {
        this._type = src._type;
        this._arg = src._arg;
    }

    public boolean change(PluginManager launcher) {
        String result = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), switch (this._type) {
            default -> ResTreatment.getString("DESKTOP_INPUT_OPEN");
            case 2 -> ResTreatment.getString("DESKTOP_INPUT_PRINT");
            case 3 -> ResTreatment.getString("DESKTOP_INPUT_WEB");
            case 4 -> ResTreatment.getString("DESKTOP_INPUT_MAIL");
        }, this._arg);
        if (result != null) {
            this._arg = result;
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }
}

