/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.general.treatment.ExecParameters;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ExecParametersIO
implements IOParameters {
    protected static final String KEY_SHELL_EXECUTE = "shell-execute";
    protected static final String KEY_JNI = "shell";
    protected static final String KEY_EXEC = "binary";
    protected static final String KEY_ARGS = "arguments";
    protected static final String KEY_DIR = "working-directory";

    ExecParametersIO() {
    }

    @Override
    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (!(parameters instanceof ExecParameters)) {
            throw new IOException("Unsupported object for TranslateIOShellExec");
        }
        ExecParameters shell = (ExecParameters)parameters;
        out.write("      <");
        out.write(KEY_SHELL_EXECUTE);
        out.write(" ");
        out.write(KEY_JNI);
        out.write("=\"");
        out.write(shell.isShellExec() ? "true" : "false");
        out.write("\"");
        out.write(" ");
        out.write(KEY_EXEC);
        out.write("=\"");
        out.write(FileUtility.convertXML((String)shell.getExec()));
        out.write("\"");
        out.write(" ");
        out.write(KEY_ARGS);
        out.write("=\"");
        out.write(FileUtility.convertXML((String)shell.getArgs()));
        out.write("\"");
        out.write(" ");
        out.write(KEY_DIR);
        out.write("=\"");
        out.write(FileUtility.convertXML((String)shell.getDir()));
        out.write("\"");
        out.write("/>\n");
    }

    @Override
    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_SHELL_EXECUTE)) {
            return null;
        }
        ExecParameters res = new ExecParameters();
        Node attr = root.getAttributes().getNamedItem(KEY_EXEC);
        if (attr != null) {
            res._exec = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_ARGS)) != null) {
            res._args = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_DIR)) != null) {
            res._dir = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_JNI)) != null) {
            res._shellExec = attr.getNodeValue().equalsIgnoreCase("true");
        }
        return res;
    }
}

