/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class MapStringToStringPanel
extends JPanel {
    private static final Logger __logger = Logger.getLogger(MapStringToStringPanel.class.getPackage().getName());
    boolean _change = false;
    List<String> _keys = new ArrayList<String>();
    List<String> _vals = new ArrayList<String>();
    Map<String, String> _data = new LinkedHashMap<String, String>();
    String _title;
    JTable _ctrlTable;
    MapStringToStringModel _modelTable;
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JPopupMenu _popupList;
    JLabel _lblTitle;
    boolean _enabled = true;

    public MapStringToStringPanel(String title) {
        this._title = title;
        this.initialise();
    }

    public void setData(Map<String, String> data) {
        this._data.clear();
        this._keys.clear();
        this._vals.clear();
        this._data.putAll(data);
        for (Map.Entry<String, String> entry : this._data.entrySet()) {
            this._keys.add(entry.getKey());
            this._vals.add(entry.getValue());
        }
        this._change = false;
    }

    public Map<String, String> getData() {
        if (this._change) {
            this._data.clear();
            int size = this._keys.size();
            for (int i = 0; i < size; ++i) {
                this._data.put(this._keys.get(i), this._vals.get(i));
            }
            this._change = false;
        }
        return Collections.unmodifiableMap(this._data);
    }

    public boolean verifyData(boolean acceptEmptyVal) {
        if (this._change) {
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            int size = this._keys.size();
            for (int i = 0; i < size; ++i) {
                String val = this._vals.get(i);
                if (!acceptEmptyVal && val.length() == 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResTreatment.msgFormat("PANEL_MSTS_VAL_ERROR", this._keys.get(i)), ResMsgVoc.getString("VOC_ERROR"), 0);
                    this._ctrlTable.setRowSelectionInterval(i, i);
                    this._ctrlTable.requestFocus();
                    return false;
                }
                String oldVal = data.put(this._keys.get(i), val);
                if (oldVal == null) continue;
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResTreatment.msgFormat("PANEL_MSTS_KEY_ERROR", this._keys.get(i)), ResMsgVoc.getString("VOC_ERROR"), 0);
                this._ctrlTable.setRowSelectionInterval(i, i);
                this._ctrlTable.requestFocus();
                return false;
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._enabled == enabled) {
            return;
        }
        this._enabled = enabled;
        this._lblTitle.setEnabled(enabled);
        this._ctrlTable.setEnabled(enabled);
        this._popupList.setEnabled(enabled);
        this._ctrlAdd.setEnabled(enabled);
        this.refreshCtrl();
    }

    protected void initialise() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD"), ResMsgCore.getString("ACTION_ADD_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = MapStringToStringPanel.this._ctrlTable.getSelectedRow();
                if (idx == -1) {
                    MapStringToStringPanel.this._modelTable.insertData(-1);
                    idx = MapStringToStringPanel.this._modelTable.getRowCount() - 1;
                } else {
                    MapStringToStringPanel.this._modelTable.insertData(idx);
                }
                MapStringToStringPanel.this._ctrlTable.editCellAt(idx, 0);
                MapStringToStringPanel.this.refreshCtrl();
            }
        };
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_REMOVE"), ResMsgCore.getString("ACTION_DEL_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = MapStringToStringPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1) {
                    MapStringToStringPanel.this._modelTable.removeData(idx);
                    MapStringToStringPanel.this.refreshCtrl();
                } else {
                    __logger.info("Bad index");
                }
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon("BUT_UP"), ResMsgVoc.getString("VOC_UP"), ResMsgCore.getString("ACTION_UP_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = MapStringToStringPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx > 0) {
                    MapStringToStringPanel.this._modelTable.down(idx);
                    MapStringToStringPanel.this._ctrlTable.setRowSelectionInterval(idx - 1, idx - 1);
                    MapStringToStringPanel.this.refreshCtrl();
                } else {
                    __logger.info("Bad index");
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DOWN"), ResMsgVoc.getString("VOC_DOWN"), ResMsgCore.getString("ACTION_DOWN_TTIP")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = MapStringToStringPanel.this._ctrlTable.getSelectedRow();
                if (idx != -1 && idx < MapStringToStringPanel.this._modelTable.getRowCount() - 1) {
                    MapStringToStringPanel.this._modelTable.up(idx);
                    MapStringToStringPanel.this._ctrlTable.setRowSelectionInterval(idx + 1, idx + 1);
                    MapStringToStringPanel.this.refreshCtrl();
                } else {
                    __logger.info("Bad index");
                }
            }
        };
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JToolBar aPanel = new JToolBar();
        aPanel.setBorder(CeciliaAction.STANDARD_BORDER);
        aPanel.setFloatable(false);
        if (this._title != null) {
            this._lblTitle = new JLabel(this._title);
            aPanel.add(this._lblTitle);
        }
        aPanel.add(Box.createGlue());
        aPanel.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        aPanel.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        aPanel.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
        this.add((Component)aPanel, new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._popupList = new JPopupMenu();
        this._popupList.add(this._ctrlAdd);
        this._popupList.add(this._ctrlDel);
        this._popupList.addSeparator();
        this._popupList.add(this._ctrlUp);
        this._popupList.add(this._ctrlDown);
        this._modelTable = new MapStringToStringModel();
        this._ctrlTable = new CeciliaTable(this._modelTable);
        this._ctrlTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        scrollTable.setComponentPopupMenu(this._popupList);
        ListSelectionModel selMod = this._ctrlTable.getSelectionModel();
        selMod.setSelectionMode(0);
        selMod.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MapStringToStringPanel.this.refreshCtrl();
            }
        });
        this._modelTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                MapStringToStringPanel.this.refreshCtrl();
            }
        });
        this.add((Component)scrollTable, new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Dimension dim = this._ctrlTable.getPreferredScrollableViewportSize();
        dim.height = 200;
        this._ctrlTable.setPreferredScrollableViewportSize(dim);
        this.refreshCtrl();
    }

    public void setPreferredHeight(int height) {
        Dimension size = this._ctrlTable.getPreferredScrollableViewportSize();
        size.height = height;
        this._ctrlTable.setPreferredScrollableViewportSize(size);
    }

    protected void refreshCtrl() {
        int idx = this._ctrlTable.getSelectedRow();
        int nbr = this._ctrlTable.getRowCount();
        this._ctrlDel.setEnabled(this._enabled && idx != -1);
        this._ctrlUp.setEnabled(this._enabled && idx != -1 && idx > 0);
        this._ctrlDown.setEnabled(this._enabled && idx != -1 && idx < nbr - 1);
    }

    class MapStringToStringModel
    extends AbstractTableModel {
        MapStringToStringModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return ResMsgVoc.getString("VOC_NAME");
            }
            if (column == 1) {
                return ResMsgVoc.getString("VOC_VALUE");
            }
            return "Error";
        }

        @Override
        public int getRowCount() {
            return MapStringToStringPanel.this._keys.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return MapStringToStringPanel.this._keys.get(rowIndex);
            }
            if (columnIndex == 1) {
                return MapStringToStringPanel.this._vals.get(rowIndex);
            }
            return "Error";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                MapStringToStringPanel.this._keys.set(rowIndex, (String)value);
                MapStringToStringPanel.this._change = true;
            } else if (columnIndex == 1) {
                MapStringToStringPanel.this._vals.set(rowIndex, (String)value);
                MapStringToStringPanel.this._change = true;
            }
        }

        public void insertData(int idx) {
            if (idx == -1) {
                idx = MapStringToStringPanel.this._keys.size();
            }
            MapStringToStringPanel.this._keys.add(idx, "key");
            MapStringToStringPanel.this._vals.add(idx, "val");
            MapStringToStringPanel.this._change = true;
            this.fireTableRowsInserted(idx, idx);
        }

        public void removeData(int idx) {
            this.fireTableRowsDeleted(idx, idx);
            MapStringToStringPanel.this._keys.remove(idx);
            MapStringToStringPanel.this._vals.remove(idx);
            MapStringToStringPanel.this._change = true;
        }

        public void down(int idx) {
            assert (idx > 0 && idx <= MapStringToStringPanel.this._keys.size() - 1) : Integer.toString(idx);
            MapStringToStringPanel.this._keys.add(idx - 1, MapStringToStringPanel.this._keys.remove(idx));
            MapStringToStringPanel.this._vals.add(idx - 1, MapStringToStringPanel.this._vals.remove(idx));
            MapStringToStringPanel.this._change = true;
            this.fireTableRowsUpdated(idx - 1, idx);
        }

        public void up(int idx) {
            assert (idx >= 0 && idx < MapStringToStringPanel.this._keys.size() - 1) : Integer.toString(idx);
            MapStringToStringPanel.this._keys.add(idx + 1, MapStringToStringPanel.this._keys.remove(idx));
            MapStringToStringPanel.this._vals.add(idx + 1, MapStringToStringPanel.this._vals.remove(idx));
            MapStringToStringPanel.this._change = true;
            this.fireTableRowsUpdated(idx, idx + 1);
        }
    }
}

