/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.general.treatment.ExecParameters;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.net.URL;
import javax.swing.Icon;

public class TreatmentExec
extends AbstractPluginModel
implements PluginMTreatment {
    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return new ExecParameters();
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        assert (this.withParameters());
        assert (parameters instanceof ExecParameters);
        ExecParameters clone = new ExecParameters((ExecParameters)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return ExecParameters.getIOParameters();
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTreatment.getString("TREAT_EXEC_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTreatment.getString("TREAT_EXEC_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "shell-execute";
        }
        if (key.equals("type")) {
            return "PluginTreatment";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-09.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public String writeDefine(Plugable launcher, Object parameters) {
        if (parameters == null || !(parameters instanceof ExecParameters)) {
            return null;
        }
        ExecParameters params = (ExecParameters)parameters;
        StringBuffer sb = new StringBuffer(128);
        sb.append("      <exec");
        sb.append(" executable='").append(params.getExec().replace('\\', '/')).append("'");
        sb.append("\n        ");
        sb.append(" dir='").append(params.getDir()).append("'");
        sb.append(">\n");
        sb.append("        <arg");
        sb.append(" line='").append(params.getArgs()).append("'");
        sb.append("/>\n");
        sb.append("        <destination file='%{log.path}'>\n");
        sb.append("          <param name='Append' value='true'/>\n");
        sb.append("          <layout name='%{log.format}'>\n");
        sb.append("            <param name='Info' value='true'/>\n");
        sb.append("            <param name='Output' value='true'/>\n");
        sb.append("          </layout>\n");
        sb.append("        </destination>\n");
        sb.append("      </exec>\n");
        return sb.toString();
    }

    @Override
    public String writeCommand(Plugable launcher, Object parameters) {
        return null;
    }
}

