/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.general.treatment.DesktopParameters;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import java.awt.Desktop;
import java.net.URL;
import javax.swing.Icon;

public class TreatmentOpen
extends AbstractPluginModel
implements PluginMTreatment {
    public TreatmentOpen() {
        if (!Desktop.isDesktopSupported()) {
            throw new Error("Desktop not supported by current system");
        }
        if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            throw new Error("Action OPEN of Desktop not supported by current system");
        }
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return new DesktopParameters(1, "%{file}");
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        DesktopParameters clone = new DesktopParameters((DesktopParameters)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return DesktopParameters.getIOParameters();
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTreatment.getString("TREAT_OPEN_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTreatment.getString("TREAT_OPEN_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "desktop-argument";
        }
        if (key.equals("type")) {
            return "PluginTreatment";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-10.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public String writeDefine(Plugable launcher, Object parameters) {
        if (parameters == null || !(parameters instanceof DesktopParameters)) {
            return null;
        }
        DesktopParameters params = (DesktopParameters)parameters;
        StringBuffer sb = new StringBuffer(128);
        sb.append("      <desktop");
        sb.append(" action='open'");
        sb.append(" argument='").append(params.getArgument()).append("'");
        sb.append("/>\n");
        return sb.toString();
    }

    @Override
    public String writeCommand(Plugable launcher, Object parameters) {
        return null;
    }
}

