/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.general.treatment.ResTreatment;
import com.dassault.cecilia.plugin.general.treatment.XsltFactory;
import com.dassault.cecilia.plugin.general.treatment.XsltParameters;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TreatmentXslt
extends AbstractPluginModel
implements PluginMTreatment {
    private static final String PROP_XSLT_FACTORY = "cecilia.treatment.TreatmentXsltFactory";
    private static boolean OPT_XSLT_FACTORY = Boolean.getBoolean("cecilia.treatment.TreatmentXsltFactory");
    private XsltOptsPanel _xsltOpts = null;
    public static final String OPT_FACTORY = TreatmentXslt.class.getName() + "#Factory";

    @Override
    public boolean withOption(Plugable plugable) {
        return OPT_XSLT_FACTORY;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        if (this._xsltOpts == null) {
            this._xsltOpts = new XsltOptsPanel();
        }
        this._xsltOpts.prepareWith(launcher);
        return this._xsltOpts;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        if (this._xsltOpts != null) {
            this._xsltOpts.prepareWith(launcher);
        }
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return new XsltParameters();
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        XsltParameters clone = new XsltParameters((XsltParameters)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return XsltParameters.getIOParameters();
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTreatment.getString("TREAT_XSLT_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTreatment.getString("TREAT_XSLT_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "xslt-treatment";
        }
        if (key.equals("type")) {
            return "PluginTreatment";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("C-11.svg"));
        }
        return super.getIcon(key);
    }

    private String getOptionnalFactory(Plugable launcher) {
        if (!this.withOption(null)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        XsltFactory factory = new XsltFactory();
        String factoryDefine = PlugableUtility.getStrOpt(launcher, OPT_FACTORY, "");
        if (factory.load(factoryDefine) && factory.getName() != null && factory.getName().length() > 0) {
            sb.append("        <factory");
            sb.append("name='").append(factory.getName()).append("'");
            Map<String, String> attrs = factory.getAttributes();
            if (attrs.size() > 0) {
                sb.append(">\n");
                for (Map.Entry<String, String> attr : attrs.entrySet()) {
                    sb.append("          <attribute");
                    sb.append(" name='").append(attr.getKey()).append("'");
                    sb.append(" value='").append(attr.getValue()).append("'");
                    sb.append("/>\n");
                }
                sb.append("        </factory>\n");
            } else {
                sb.append("/>\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String writeDefine(Plugable launcher, Object parameters) {
        if (parameters == null || !(parameters instanceof XsltParameters)) {
            return null;
        }
        XsltParameters params = (XsltParameters)parameters;
        StringBuffer sb = new StringBuffer(128);
        sb.append("      <style");
        sb.append(" style='").append(params.getStyle().replace('\\', '/')).append("'");
        sb.append("\n        ");
        sb.append(" srcfile='").append(params.getInput()).append("'");
        sb.append(" destfile='").append(params.getOutput()).append("'");
        sb.append(" failonerror='").append(false).append("'");
        sb.append(">\n");
        Map<String, String> xsltParams = params.getParameters();
        Map<String, String> xsltOutProps = params.getOutputProperties();
        String factory = this.getOptionnalFactory(launcher);
        if (xsltParams.size() > 0 || xsltOutProps.size() > 0 || factory.length() > 0) {
            if (factory.length() > 0) {
                sb.append(factory);
            }
            for (Map.Entry<String, String> param : xsltParams.entrySet()) {
                sb.append("        <param");
                sb.append(" name='").append(param.getKey()).append("'");
                sb.append(" value='").append(param.getValue()).append("'");
                sb.append("/>\n");
            }
            for (Map.Entry<String, String> outProp : xsltOutProps.entrySet()) {
                sb.append("        <outputproperty");
                sb.append(" name='").append(outProp.getKey()).append("'");
                sb.append(" value='").append(outProp.getValue()).append("'");
                sb.append("/>\n");
            }
        }
        sb.append("        <destination file='%{log.path}'>\n");
        sb.append("          <param name='Append' value='true'/>\n");
        sb.append("          <layout name='%{log.format}'/>\n");
        sb.append("        </destination>\n");
        sb.append("      </style>\n");
        return sb.toString();
    }

    @Override
    public String writeCommand(Plugable launcher, Object parameters) {
        return null;
    }

    class XsltOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        XsltFactory _factory;
        JTextArea _ctrlFactory;
        JButton _ctrlModify;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            String factory = PlugableUtility.getStrOpt(this._launcher, OPT_FACTORY, "");
            this._factory.load(factory);
            this._ctrlFactory.setText(this._factory.resume());
        }

        public XsltOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            this._factory = new XsltFactory();
            JPanel root = new JPanel(new GridBagLayout());
            root.add((Component)new JLabel(ResTreatment.getString("XSLT_FACTORY")), new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
            this._ctrlModify = new JButton(ResTreatment.getString("GLOBAL_MODIFY"));
            this._ctrlModify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (XsltOptsPanel.this._factory.modify(XsltOptsPanel.this._ctrlModify)) {
                        String factory = XsltOptsPanel.this._factory.save();
                        XsltOptsPanel.this._launcher.setOption(OPT_FACTORY, factory);
                        XsltOptsPanel.this._ctrlFactory.setText(XsltOptsPanel.this._factory.resume());
                    }
                }
            });
            root.add((Component)this._ctrlModify, new GridBagConstraints(1, 0, 1, 1, 10.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            this._ctrlFactory = new JTextArea(5, 30);
            this._ctrlFactory.setText("");
            this._ctrlFactory.setEditable(false);
            this._ctrlFactory.setEnabled(false);
            this._ctrlFactory.setTabSize(2);
            JScrollPane scrollFactory = new JScrollPane(this._ctrlFactory);
            root.add((Component)scrollFactory, new GridBagConstraints(0, 1, 2, 1, 10.0, 10.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void trash() {
        }

        @Override
        public String getInfo(String key) {
            return TreatmentXslt.this.getInfo(key);
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }
    }
}

