/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.treatment;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.general.treatment.XsltParameters;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XsltParametersIO
implements IOParameters {
    protected static final String KEY_XSLT_PARAMS = "xslt-treatment";
    protected static final String KEY_INPUT = "input";
    protected static final String KEY_OUTPUT = "output";
    protected static final String KEY_STYLE = "style";
    protected static final String KEY_PARAM = "parameter";
    protected static final String KEY_OUTPROP = "output-property";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_VALUE = "value";
    private static final Logger __logger = Logger.getLogger(XsltParametersIO.class.getPackage().getName());

    XsltParametersIO() {
    }

    @Override
    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (parameters instanceof XsltParameters) {
            XsltParameters xslt = (XsltParameters)parameters;
            out.write("      <");
            out.write(KEY_XSLT_PARAMS);
            out.write(" ");
            out.write(KEY_INPUT);
            out.write("=\"");
            out.write(xslt.getInput());
            out.write("\"");
            out.write(" ");
            out.write(KEY_OUTPUT);
            out.write("=\"");
            out.write(xslt.getOutput());
            out.write("\"");
            out.write(" ");
            out.write(KEY_STYLE);
            out.write("=\"");
            out.write(xslt.getStyle());
            out.write("\"");
            out.write(">\n");
            for (Map.Entry<String, String> param : xslt.getParameters().entrySet()) {
                out.write("        <");
                out.write(KEY_PARAM);
                out.write(" ");
                out.write(KEY_NAME);
                out.write("=\"");
                out.write(param.getKey());
                out.write("\"");
                out.write(" ");
                out.write(KEY_VALUE);
                out.write("=\"");
                out.write(param.getValue());
                out.write("\"");
                out.write("/>\n");
            }
            for (Map.Entry<String, String> param : xslt.getOutputProperties().entrySet()) {
                out.write("        <");
                out.write(KEY_OUTPROP);
                out.write(" ");
                out.write(KEY_NAME);
                out.write("=\"");
                out.write(param.getKey());
                out.write("\"");
                out.write(" ");
                out.write(KEY_VALUE);
                out.write("=\"");
                out.write(param.getValue());
                out.write("\"");
                out.write("/>\n");
            }
        } else {
            throw new IOException("Unsupported object for XsltParametersIO");
        }
        out.write("      </");
        out.write(KEY_XSLT_PARAMS);
        out.write(">\n");
    }

    @Override
    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_XSLT_PARAMS)) {
            return null;
        }
        XsltParameters res = new XsltParameters();
        Node attr = root.getAttributes().getNamedItem(KEY_INPUT);
        if (attr != null) {
            res._inputKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_OUTPUT)) != null) {
            res._outputKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_STYLE)) != null) {
            res._xsltStyle = attr.getNodeValue();
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            String key;
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (childName.equals(KEY_PARAM)) {
                attr = child.getAttributes().getNamedItem(KEY_NAME);
                if (attr == null || attr.getNodeValue().length() == 0) {
                    __logger.warning("Parsing error : 'parameter' without 'name' attribute");
                    continue;
                }
                key = attr.getNodeValue();
                attr = child.getAttributes().getNamedItem(KEY_VALUE);
                if (attr == null || attr.getNodeValue().length() == 0) {
                    __logger.warning("Parsing error : 'parameter' without 'value' attribute");
                    continue;
                }
                res._xsltParameters.put(key, attr.getNodeValue());
                continue;
            }
            if (!childName.equals(KEY_OUTPROP)) continue;
            attr = child.getAttributes().getNamedItem(KEY_NAME);
            if (attr == null || attr.getNodeValue().length() == 0) {
                __logger.warning("Parsing error : 'output-propertie' without 'name' attribute");
                continue;
            }
            key = attr.getNodeValue();
            attr = child.getAttributes().getNamedItem(KEY_VALUE);
            if (attr == null || attr.getNodeValue().length() == 0) {
                __logger.warning("Parsing error : 'output-propertie' without 'value' attribute");
                continue;
            }
            res._xsltOutProperties.put(key, attr.getNodeValue());
        }
        return res;
    }
}

