/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import java.io.StringWriter;

public class LimitStringWriter
extends StringWriter {
    int _limit;
    int _current;

    public LimitStringWriter() {
        this._limit = 50;
        this._current = 0;
    }

    public LimitStringWriter(int limit, int initialSize) {
        super(initialSize);
        this._limit = limit;
        this._current = 0;
    }

    public LimitStringWriter(int limit) {
        this._limit = limit;
        this._current = 0;
    }

    public boolean overflow() {
        return this._current >= this._limit;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (!this.overflow()) {
            super.write(cbuf, off, len);
            for (int i = 0; i < len; ++i) {
                if (cbuf[off + i] == '\n') {
                    ++this._current;
                }
                if (!this.overflow()) continue;
                super.write("\n...\n");
            }
        }
    }

    @Override
    public void write(int c) {
        if (!this.overflow()) {
            super.write(c);
            if (c == 10) {
                ++this._current;
            }
            if (this.overflow()) {
                super.write("\n...\n");
            }
        }
    }

    @Override
    public void write(String str, int off, int len) {
        if (!this.overflow()) {
            super.write(str, off, len);
            for (int i = 0; i < len; ++i) {
                if (str.charAt(off + i) != '\n') continue;
                ++this._current;
            }
            if (this.overflow()) {
                super.write("\n...\n");
            }
        }
    }

    @Override
    public void write(String str) {
        if (!this.overflow()) {
            super.write(str);
            for (int i = str.length() - 1; i >= 0; --i) {
                if (str.charAt(i) != '\n') continue;
                ++this._current;
            }
            if (this.overflow()) {
                super.write("\n...\n");
            }
        }
    }
}

