/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPlugTaskBan;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginDlgFMEADiff;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginCmdFMEADiff
extends AbstractPluginModel
implements PluginMAction {
    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_DIFF_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_DIFF_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A3-01.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public void createSession(Plugable launch, Object parameters) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        InputStream script = this.getClass().getResourceAsStream("BanScriptFMEADiff.xml");
        if (script == null) {
            Logger.getLogger(PluginCmdFMEADiff.class.getPackage().getName()).severe("Resource script not found : BanScriptFMEADiff.xml");
            return;
        }
        PluginDlgFMEADiff dlg = new PluginDlgFMEADiff(launch.getWindow());
        if (!dlg.DoModal(launch)) {
            return;
        }
        BanEntry entry = null;
        try {
            entry = new BanEntry();
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdFMEADiff.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return;
        }
        entry.setUserProperty("fmeadiff.file1", dlg.getInput1());
        entry.setUserProperty("fmeadiff.file2", dlg.getInput2());
        entry.setUserProperty("fmeadiff.select.event", dlg.getSelectEvent());
        entry.setUserProperty("fmeadiff.select.state", dlg.getSelectState());
        entry.setUserProperty("fmeadiff.select.flow", dlg.getSelectFlow());
        entry.setUserProperty("fmeadiff.output", dlg.getOutput());
        AbstractPlugTaskBan task = new AbstractPlugTaskBan(-1L, launcher, entry, new BanInputStream(script, "FMEADiff")){

            @Override
            protected String getDesc() {
                return this.getInfo("plugin.name");
            }

            @Override
            protected String getName() {
                return "FMEADiff";
            }

            @Override
            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A3-01.svg"));
                }
                return super.getIcon(key);
            }

            @Override
            protected void displayResult() {
                BanEntry ban = this.getBanProcess();
                Object result = ban.getValueOfVariable("fmeadiff.result");
                if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getComponent()), ResSeqGen.getString("DLG_DIFF_FMEA_RESULT_GOOD"), this.getDesc(), 0);
                } else {
                    this.displayPanelResult();
                }
            }

            @Override
            protected void addResultToPanel(AbstractPlugPanelInfo pane) throws IOException {
                BanEntry ban = this.getBanProcess();
                Object obj = ban.getIdObject("fmeadiff.diff");
                pane.append(obj.toString());
            }
        };
        launcher.addTask(task, -1L);
    }
}

