/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.lib.util.io.IndentWriter;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import com.dassault.cecilia.plugin.mbsa.viewer.DefaultFileFilter;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;
import org.w3c.dom.Element;

public class PluginTargetModelSeq
extends TargetModel {
    public static final int SEQ = 2;
    public static final int PROP_DEF_PLUGIN_SEQGEN_ORDER_MAX = 10;
    public static final String PROP_PLUGIN_SEQGEN_ORDER_MAX = "cecilia.mbsa.plugin.seqgen.MaxOrder";
    protected int _order;
    protected JComboBox _cbb;

    public int getOrder() {
        return this._order;
    }

    public void setFilter(DefaultFileFilter filter) {
        this._filter = filter;
        if (this._filter.getDefaultAccessory() == null) {
            JLabel lbl = new JLabel(ResSeqGen.getString("PRV_CMD_SEQ_FILTER"));
            this._filter.setDefaultAccessory(lbl);
        }
    }

    public PluginTargetModelSeq(int order) {
        this._order = order;
        this._cbb = new JComboBox();
        int limit = Integer.getInteger(PROP_PLUGIN_SEQGEN_ORDER_MAX, 10);
        for (int i = 1; i < limit; ++i) {
            this._cbb.addItem(i);
        }
    }

    @Override
    public Object clone() {
        PluginTargetModelSeq clone = new PluginTargetModelSeq(0);
        clone.copy(this);
        return clone;
    }

    @Override
    protected void copy(TargetModel model) {
        super.copy(model);
        if (model instanceof PluginTargetModelSeq) {
            this._order = ((PluginTargetModelSeq)model).getOrder();
            this._cbb.setSelectedIndex(this._order - 1);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getDefaultWidth(int c) {
        if (c == 2) {
            return 150;
        }
        return super.getDefaultWidth(c);
    }

    @Override
    public String getColumnName(int c) {
        if (c == 2) {
            return ResSeqGen.getString("PRV_CMD_SEQ_ORDER");
        }
        return super.getColumnName(c);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 2) {
            return Integer.class;
        }
        return super.getColumnClass(c);
    }

    @Override
    public TableCellEditor getEditor(int c) {
        if (c == 2) {
            return new DefaultCellEditor(this._cbb);
        }
        return super.getEditor(c);
    }

    @Override
    public Object getValueAt(int c) {
        if (c == 2) {
            return this._cbb.getSelectedItem();
        }
        return super.getValueAt(c);
    }

    @Override
    public boolean setValueAt(Object item, int c) {
        if (c == 2) {
            if (item instanceof Integer) {
                this._order = (Integer)item;
                this._cbb.setSelectedIndex(this._order - 1);
                return true;
            }
            return false;
        }
        return super.setValueAt(item, c);
    }

    @Override
    public boolean withError(int c) {
        if (c == 2) {
            return this._order < 1;
        }
        return super.withError(c);
    }

    @Override
    public boolean withError() {
        return this._order < 1 || super.withError();
    }

    @Override
    public void saveProperties(IndentWriter writer) throws IOException {
        super.saveProperties(writer);
        writer.write(" order=\"");
        writer.write(Integer.toString(this._order));
        writer.write("\"");
    }

    @Override
    public void load(Element xmlTgt, TargetModel defTgt, int outputType) {
        super.load(xmlTgt, defTgt, outputType);
        String order = xmlTgt.getAttribute("order");
        if (order != null && !order.isEmpty()) {
            try {
                this._order = Integer.parseInt(order);
            }
            catch (NumberFormatException e) {
                this._order = 0;
            }
        } else {
            this._order = 3;
        }
        this._cbb.setSelectedIndex(this._order - 1);
    }

    @Override
    public String replaceTgt(String tgtPath) {
        tgtPath = super.replaceTgt(tgtPath);
        tgtPath = tgtPath.replaceAll("%order%", Integer.toString(this._order));
        return tgtPath;
    }
}

