/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.DiffFMEA;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationFile;
import com.dassault.cecilia.lib.util.destination.DestinationString;
import com.dassault.cecilia.lib.util.xmlparser.xmlException;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginTaskFMEADiff
extends DiffFMEA
implements PlugTask {
    Plugable _launcher;
    File _outputFile;

    public PluginTaskFMEADiff(Plugable launcher, File file1, File file2) {
        super(file1, file2);
        this._launcher = launcher;
    }

    public void setOutputFile(File output) {
        this._outputFile = output;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public void requestSuspend(boolean high) {
        this.requestSuspend();
    }

    private String getDefaultTitle() {
        return this.getInfo("ptask.desc");
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return "FMEADiff";
        }
        if (key.equals("ptask.desc")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_DIFF_NAME");
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A3-01.svg"));
        }
        return null;
    }

    @Override
    public void run() {
        this._state = DiffFMEA.State.INIT;
        DestinationString dest = new DestinationString(1000);
        this.addDestination((Destination)dest);
        if (this._outputFile != null) {
            DestinationFile destFile = new DestinationFile(this._outputFile, false);
            this.addDestination((Destination)destFile);
        }
        String header = ResSeqGen.getString("DLG_DIFF_FMEA_HEADER");
        try {
            boolean result = this.run(header);
            if (result) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), ResSeqGen.getString("DLG_DIFF_FMEA_RESULT_GOOD"), this.getDefaultTitle(), 1);
            } else {
                this.displayResult(dest.getString());
            }
        }
        catch (IOException iOException) {
        }
        catch (xmlException xmlException2) {
            // empty catch block
        }
    }

    private void displayResult(String info) {
        AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

            @Override
            protected String getLabel() {
                return PluginTaskFMEADiff.this.getDefaultTitle();
            }

            @Override
            public String getInfo(String key) {
                if (key.equals("ppanel.title")) {
                    return "Info - " + PluginTaskFMEADiff.this.getDefaultTitle();
                }
                if (key.equals("ppanel.default.width")) {
                    return "600";
                }
                if (key.equals("ppanel.default.height")) {
                    return "480";
                }
                return super.getInfo(key);
            }
        };
        pPane.append(info);
        this._launcher.addPanel(pPane, -1L);
    }

    class DoubleWriter
    extends Writer {
        Writer _writer1;
        Writer _writer2;

        DoubleWriter(Writer writer1, Writer writer2) {
            this._writer1 = writer1;
            this._writer2 = writer2;
        }

        @Override
        public void close() throws IOException {
            this._writer1.close();
            this._writer2.close();
        }

        @Override
        public void flush() throws IOException {
            this._writer1.flush();
            this._writer2.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this._writer1.write(cbuf, off, len);
            this._writer2.write(cbuf, off, len);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this._writer1.write(cbuf);
            this._writer2.write(cbuf);
        }

        @Override
        public void write(int c) throws IOException {
            this._writer1.write(c);
            this._writer2.write(c);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this._writer1.write(str, off, len);
            this._writer2.write(str, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            this._writer1.write(str);
            this._writer2.write(str);
        }
    }
}

