/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPlugTask;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.DiffFMEA;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.GenFMEA;
import com.dassault.cecilia.lib.util.ControllableAction;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationFile;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginTaskFMEAVerif
extends AbstractPlugTask {
    Plugable _launcher;
    IModel _model;
    List<PluginMStepper> _steppers;
    List<File> _results;
    int _idx;
    int _max;
    boolean _genFMEA;
    Stepper _currentStepper;
    ControllableAction _currentProcess;
    String _selectEvent;
    String _selectState;
    String _selectFlow;
    String _filterEvent;
    String _filterState;
    String _filterFlow;
    boolean _changeValue;
    File _fileResult;
    private static final String LINE = "============================================================\n";

    public PluginTaskFMEAVerif(Plugable launcher, IModel model) {
        this._launcher = launcher;
        this._selectFlow = "";
        this._selectState = "";
        this._selectEvent = "";
        this._filterFlow = "";
        this._filterState = "";
        this._filterEvent = "";
        this._changeValue = true;
        this._genFMEA = true;
        this._idx = -1;
        this._max = -1;
        this._fileResult = null;
    }

    public boolean prepareAction() {
        int i;
        List keySteppers = this._launcher.getPlugins("PluginStepper");
        this._steppers = new ArrayList<PluginMStepper>();
        for (i = 0; i < keySteppers.size(); ++i) {
            PluginModel plugin = this._launcher.getPlugin((String)keySteppers.get(i));
            if (plugin == null || !(plugin instanceof PluginMStepper)) continue;
            this._steppers.add((PluginMStepper)plugin);
        }
        this._max = this._steppers.size();
        this._idx = -1;
        if (this._max < 2) {
            return false;
        }
        this._results = new ArrayList<File>();
        try {
            for (i = 0; i < this._max; ++i) {
                this._results.add(File.createTempFile("FMEAVerif", ".log"));
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void setSelects(String selectEvent, String selectState, String selectFlow, boolean changeValue) {
        this._selectEvent = selectEvent;
        this._selectState = selectState;
        this._selectFlow = selectFlow;
        this._changeValue = changeValue;
    }

    public void setFilters(String filterEvent, String filterState, String filterFlow) {
        this._filterEvent = filterEvent;
        this._filterState = filterState;
        this._filterFlow = filterFlow;
    }

    public void setOutputFile(File fileResult) {
        this._fileResult = fileResult;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    private String getDefaultTitle() {
        return this.getInfo("ptask.desc");
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return "FMEAVerif";
        }
        if (key.equals("ptask.desc")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_VERIF_NAME");
        }
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            StringBuffer sb = new StringBuffer(128);
            if (this._genFMEA) {
                sb.append("Gen ").append(this._idx + 1).append("/").append(this._max);
                if (this._currentProcess != null) {
                    sb.append(" - ").append(this._currentProcess.getInfo(key));
                } else {
                    sb.append(" - Create Stepper");
                }
            } else if (this._idx < this._max) {
                sb.append("Diff ").append(this._idx).append("/").append(this._max - 1);
                if (this._currentProcess != null) {
                    sb.append(" - ").append(this._currentProcess.getInfo(key));
                } else {
                    sb.append(" - Init");
                }
            } else {
                sb.append("Finish");
            }
            return sb.toString();
        }
        if (key.equals("process.p1000")) {
            if (this._currentProcess != null) {
                return this._currentProcess.getInfo(key);
            }
            return "-1";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ptask.icon")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A3-02.svg"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            boolean error = false;
            try {
                this._genFMEA = true;
                this._idx = 0;
                while (!this.checkStopped() && this._idx < this._max && !error) {
                    this.checkSuspended(false);
                    this._currentStepper = this._steppers.get(this._idx).createStepper(this._launcher, null);
                    if (this._currentStepper == null) {
                        throw new InterruptedException();
                    }
                    FileWriter writer = new FileWriter(this._fileResult, true);
                    writer.write(ResSeqGen.msgFormat("DLG_GEN_FMEA_HEADER", this._steppers.get(this._idx).getInfo("plugin.name"), LINE, this._idx == 0 ? "" : "\n\n"));
                    writer.close();
                    this._currentProcess = new GenFMEA(this._currentStepper, this._model.getName(), this._results.get(this._idx));
                    DestinationFile dest = new DestinationFile(this._fileResult, true);
                    dest.setLayout((Layout)new LogGenLayoutSimple());
                    ((GenFMEA)this._currentProcess).addDestination((Destination)dest);
                    ((GenFMEA)this._currentProcess).setSelectors(this._selectEvent, this._selectState, this._selectFlow, this._changeValue);
                    error = ((GenFMEA)this._currentProcess).run();
                    this._currentProcess = null;
                    this._currentStepper = null;
                    ++this._idx;
                }
                this._genFMEA = false;
                this._idx = 1;
                while (!this.checkStopped() && this._idx < this._max && !error) {
                    this.checkSuspended(false);
                    String header = "============================================================\n\n\n" + ResSeqGen.getString("DLG_DIFF_FMEA_HEADER");
                    this._currentProcess = new DiffFMEA(this._results.get(0), this._results.get(this._idx));
                    ((DiffFMEA)this._currentProcess).setFilters(this._filterEvent, this._filterState, this._filterFlow);
                    ((DiffFMEA)this._currentProcess).addDestination((Destination)new DestinationFile(this._fileResult, true));
                    boolean result = ((DiffFMEA)this._currentProcess).run(header, this._steppers.get(0).getInfo("plugin.name"), this._steppers.get(this._idx).getInfo("plugin.name"));
                    if (result) {
                        FileWriter writer = new FileWriter(this._fileResult, true);
                        writer.write(header);
                        writer.write(ResSeqGen.getString("DLG_DIFF_FMEA_RESULT_GOOD"));
                        writer.write("\n");
                        writer.close();
                    }
                    this._currentProcess = null;
                    ++this._idx;
                }
                if (this._fileResult.length() <= 0L) break block14;
                this.displayResult(this._fileResult);
            }
            catch (InterruptedException i) {
                if (error && !this._fileResult.delete()) {
                    this._fileResult.deleteOnExit();
                }
                for (int i2 = 0; i2 < this._max; ++i2) {
                    File result = this._results.get(i2);
                    if (result.delete()) continue;
                    result.deleteOnExit();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), e.getMessage(), this.getDefaultTitle(), 0);
            }
            finally {
                if (error && !this._fileResult.delete()) {
                    this._fileResult.deleteOnExit();
                }
                for (int i = 0; i < this._max; ++i) {
                    File result = this._results.get(i);
                    if (result.delete()) continue;
                    result.deleteOnExit();
                }
            }
        }
    }

    private void displayResult(File pathInfo) {
        try {
            AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

                @Override
                protected String getLabel() {
                    return PluginTaskFMEAVerif.this.getDefaultTitle();
                }

                @Override
                public String getInfo(String key) {
                    if (key.equals("ppanel.title")) {
                        return "Info - " + PluginTaskFMEAVerif.this.getDefaultTitle();
                    }
                    if (key.equals("ppanel.default.width")) {
                        return "600";
                    }
                    if (key.equals("ppanel.default.height")) {
                        return "480";
                    }
                    return super.getInfo(key);
                }
            };
            pPane.load(pathInfo);
            this._launcher.addPanel(pPane, this._model.getUID());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._launcher.getWindow()), "Display result file : " + e1.getMessage(), this.getDefaultTitle(), 0);
        }
    }

    @Override
    public void requestSuspend(boolean hight) {
        if (this._currentProcess != null) {
            this._currentProcess.requestSuspend();
        }
        super.requestSuspend(hight);
    }

    @Override
    public void requestResume() {
        super.requestResume();
        if (this._currentProcess != null) {
            this._currentProcess.requestResume();
        }
    }

    @Override
    public void requestStop() {
        if (this._currentProcess != null) {
            this._currentProcess.requestStop();
        }
        super.requestStop();
    }
}

