/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.destination.DestinationRecord;
import com.dassault.cecilia.plugin.mbsa.translator.BanTranslateHelper;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginFormat;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.xml.sax.Locator;

public class PluginCmdJSyntax
extends TranslatePluginFormat
implements PluginMAction {
    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_CMD_SYNTAX_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTrans.getString("PLUG_CMD_SYNTAX_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "alt S";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("sub-type")) {
            return "PluginActionSyntax";
        }
        if (key.equals("plugin.default")) {
            return "true";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A1-03.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public void createSession(Plugable launcher, Object params) {
        BanEntry ban;
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        BanTranslateHelper helper = new BanTranslateHelper(launcher).setModel(model);
        try {
            ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            helper.showErrorMessage("TRANS_ERROR_LICENSE", e, new Object[0]);
            return;
        }
        try {
            this.prepareBanEntry(launcher, ban, model, params);
            ban.execute(this.getStreamOfBanScript());
            this.successVerify(launcher, model.getUID(), params);
        }
        catch (BanProcessException e) {
            Object obj = ban.getIdObject("altr-log-ref");
            if (obj != null) {
                DestinationRecord dest = (DestinationRecord)obj;
                if (dest != null && dest.getNbrRecord() > 0) {
                    helper.showParseError(dest.getRecords(), e.getMessage());
                } else {
                    obj = null;
                }
            }
            if (obj == null) {
                Locator loc;
                Throwable exc = e;
                if (e.getException() != null) {
                    exc = e.getException();
                }
                if ((loc = e.getLocator()) != null) {
                    helper.showErrorMessage("TRANS_ERROR_BAN", exc, "[Debug info : " + loc.getLineNumber() + "]");
                } else {
                    helper.showErrorMessage("TRANS_ERROR_BAN", exc, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            helper.showErrorMessage("TRANS_ERROR_BAN", e, new Object[0]);
        }
    }

    public void testCreateSession(IModel model, Object params) throws Throwable {
        BanEntry ban = new BanEntry();
        try {
            this.prepareBanEntry(null, ban, model, params);
            ban.execute(this.getStreamOfBanScript());
        }
        catch (BanProcessException e) {
            Object obj = ban.getIdObject("altr-log-ref");
            if (obj != null) {
                DestinationRecord dest = (DestinationRecord)obj;
                for (String msg : dest.getRecords()) {
                    System.err.println(msg);
                }
            }
            BanProcessException exc = e;
            throw exc;
        }
    }

    protected void prepareBanEntry(Plugable launcher, BanEntry ban, IModel model, Object params) {
        ban.setUserProperty("altr.uid", Long.toString(model.getUID()));
        ban.setUserProperty("altr.input", model.getFile().getAbsolutePath());
        ban.setUserProperty("altr.main", model.getName());
        ban.setUserProperty("altr.log.class", DestinationRecord.class.getName());
        ban.setUserProperty("altr.log.format", "txt");
        ban.setUserProperty("altr.log.opt.key", "Limit");
        ban.setUserProperty("altr.log.opt.val", "100");
    }

    protected BanInputStream getStreamOfBanScript() {
        String name = this.getNameOfBanScript();
        BanInputStream inputStream = new BanInputStream(this.getClass().getResourceAsStream(name), name);
        return inputStream;
    }

    protected String getNameOfBanScript() {
        return "BanScriptSyntax.xml";
    }

    protected void successVerify(Plugable launcher, long uid, Object params) {
        JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResTrans.getString("PRV_PLUG_SYNTAX_GOOD"), ResTrans.getString("DEF_TITLE"), 1);
    }
}

