/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.JNIUtil;
import com.dassault.cecilia.lib.util.io.CopyStream;
import com.dassault.cecilia.plugin.mbsa.translator.ParametersShellExec;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JOptionPane;

public class PluginCmdShellExec
extends AbstractPluginModel
implements PluginMAction {
    @Override
    public boolean withOption(Plugable plugable) {
        return false;
    }

    @Override
    public boolean withParameters() {
        return true;
    }

    @Override
    public Object getDefaultParameters(PluginManager plugable) {
        return new ParametersShellExec();
    }

    @Override
    public Object changeParameters(PluginManager parent, Object parameters) {
        assert (this.withParameters());
        assert (parameters instanceof ParametersShellExec);
        ParametersShellExec clone = new ParametersShellExec((ParametersShellExec)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    @Override
    public IOParameters getIOParameters() {
        return ParametersShellExec.getIOParameters();
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_CMD_SHELL_EXEC_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTrans.getString("PLUG_CMD_SHELL_EXEC_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "shell-execute";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    @Override
    public void createSession(Plugable launcher, Object parameters) {
        File outFile;
        if (!(parameters instanceof ParametersShellExec)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), "Parameters not know for this plugin", ResTrans.getString("DEF_TITLE"), 0);
            return;
        }
        ParametersShellExec params = (ParametersShellExec)parameters;
        PluginMTranslate plug = params.VerifyData(launcher);
        if (plug == null) {
            return;
        }
        Translator trans = plug.createTranslator(launcher, params.getTrParams());
        if (trans == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResTrans.getString("ERR_TRANSLATOR"), ResTrans.getString("DEF_TITLE"), 0);
            return;
        }
        try {
            outFile = File.createTempFile("ShellExec", ".alt");
            outFile.deleteOnExit();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResTrans.getString("ERR_TMP_FILE"), ResTrans.getString("DEF_TITLE"), 0);
            return;
        }
        if (!trans.translate(outFile, true)) {
            return;
        }
        String outPath = outFile.getAbsolutePath();
        outPath = outPath.replace('\\', '/');
        String args = params.getArgs().replaceAll("\\$file\\$", "\"" + outPath + "\"");
        try {
            if (params.isShellExec()) {
                if (!JNIUtil.ShellExec((String)params.getExec(), (String)args, (String)params.getDir(), (boolean)true)) {
                    throw new IOException("ShellExecute error ...");
                }
            } else {
                String name = params.getExec();
                StringBuffer cmds = new StringBuffer(128 + args.length());
                cmds.append(name);
                cmds.append(" ");
                cmds.append(args);
                Process exec = Runtime.getRuntime().exec(cmds.toString(), null, new File(params.getDir()));
                CopyStream clearOut = new CopyStream("Out : " + name).setIn(exec.getInputStream()).setOut((OutputStream)System.out);
                CopyStream clearErr = new CopyStream("Err : " + name).setIn(exec.getErrorStream()).setOut((OutputStream)System.err);
                clearOut.start();
                clearErr.start();
            }
        }
        catch (IOException e) {
            StringBuffer mess = new StringBuffer(128);
            mess.append("Execute error : \n");
            mess.append(e.getMessage());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), mess.toString());
        }
    }
}

