/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.translator.PluginCmdJSyntax;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateOptions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginCmdStatistics
extends PluginCmdJSyntax
implements PluginMAction {
    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_CMD_STATISTICS_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTrans.getString("PLUG_CMD_STATISTICS_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "";
        }
        if (key.equals("sub-type")) {
            return "";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A1-01.svg"));
        }
        return super.getIcon(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSession(Plugable launcher, Object params) {
        File outFile;
        boolean deleteOutFile = true;
        try {
            outFile = File.createTempFile("Statistics", ".txt");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), ResTrans.getString("ERR_TMP_FILE"), ResTrans.getString("DEF_TITLE"), 0);
            return;
        }
        try {
            super.createSession(launcher, outFile);
        }
        finally {
            if (deleteOutFile) {
                if (!outFile.delete()) {
                    outFile.deleteOnExit();
                }
            } else {
                outFile.deleteOnExit();
            }
        }
    }

    @Override
    protected void prepareBanEntry(Plugable launcher, BanEntry ban, IModel model, Object params) {
        super.prepareBanEntry(launcher, ban, model, params);
        File outFile = (File)params;
        ban.setUserProperty("altr.output", outFile.getAbsolutePath());
        ban.setUserProperty("altr.translate.ccf", Boolean.toString(TranslateOptions.withTranslateCCF(launcher)));
        ban.setUserProperty("altr.dataflow.verify", Boolean.toString(TranslateOptions.withDataFlowVerify(launcher)));
        ban.setUserProperty("altr.verify.before", TranslateOptions.listVerifyBefore(launcher, 2));
        ban.setUserProperty("altr.verify.after", TranslateOptions.listVerifyAfter(launcher, 2));
    }

    @Override
    protected String getNameOfBanScript() {
        return "BanScriptStatistics.xml";
    }

    @Override
    protected void successVerify(Plugable launcher, long uid, Object params) {
        AbstractPlugPanelInfo pPane = new AbstractPlugPanelInfo(){

            @Override
            protected String getLabel() {
                return "";
            }

            @Override
            public String getInfo(String key) {
                if (key.equals("ppanel.title")) {
                    return ResTrans.getString("PRV_PLUG_STATISTICS_LBL");
                }
                if (key.equals("ppanel.default.width")) {
                    return "400";
                }
                if (key.equals("ppanel.default.height")) {
                    return "450";
                }
                return super.getInfo(key);
            }

            @Override
            public Icon getIcon(String key) {
                if (key.equals("ppanel.icon")) {
                    return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A1-01.svg"));
                }
                return null;
            }
        };
        try {
            File outFile = (File)params;
            pPane.load(outFile);
            launcher.addPanel(pPane, uid);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(launcher.getWindow()), "Display result file : " + e1.getMessage(), ResTrans.getString("DEF_TITLE"), 0);
        }
    }
}

