/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginDataFlow;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginMec5;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginMocaRP;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginOTools;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginOToolsF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class PluginCmdTranslate
extends AbstractPluginModel
implements PluginMAction {
    private static final String PROP_CMDTRANSLATE_OTOOLSFLATNESS = "cecilia.mbsa.plugin.translator.TranslateOToolsFlatness";
    protected static final String PREF_FORMAT = PluginCmdTranslate.class.getName() + "#Format";
    protected static final String PREF_RENAME = PluginCmdTranslate.class.getName() + "#Rename";

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_CMD_TRANSLATE_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResTrans.getString("PLUG_CMD_TRANSLATE_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A1-09.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public void createSession(Plugable launcher, Object parameters) {
        DlgLaunch dlg = new DlgLaunch(launcher.getWindow());
        dlg._defPath = new File(PlugableUtility.getStrOpt(launcher, "plugable.option.path", "."));
        String frm = PlugableUtility.getStrOpt(launcher, PREF_FORMAT, "DataFlow");
        for (int i = dlg._ctrlFormats.getItemCount() - 1; i >= 0; --i) {
            if (!frm.equals(((Format)((Object)dlg._ctrlFormats.getItemAt(i))).getCode())) continue;
            dlg._ctrlFormats.setSelectedIndex(i);
            break;
        }
        dlg._ctrlRename.setSelected(PlugableUtility.getBoolOpt(launcher, PREF_RENAME, false));
        if (!dlg.DoModal()) {
            return;
        }
        File file = new File(dlg._ctrlPath.getText().trim());
        Format format = (Format)((Object)dlg._ctrlFormats.getSelectedItem());
        launcher.setOption(PREF_RENAME, dlg._ctrlRename.isSelected() ? "true" : "false");
        launcher.setOption(PREF_FORMAT, format.getCode());
        launcher.setOption("plugable.option.path", file.getParent());
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        if (dlg._ctrlRename.isSelected()) {
            opts.put("altr.rename.enable", "true");
            String trace = dlg._ctrlTrace.getText().trim();
            if (trace.length() > 0) {
                opts.put("altr.rename.trace", trace);
            }
        }
        Translator trans = format.getTranslate().createTranslator(launcher, opts);
        trans.translate(file, true);
    }

    class DlgLaunch
    extends JDialogCecilia {
        JTextField _ctrlPath;
        JComboBox _ctrlFormats;
        JCheckBox _ctrlRename;
        JTextField _ctrlTrace;
        File _defPath;
        JFileChooser _fileChooserResult;

        JFileChooser getFCResult() {
            if (this._fileChooserResult == null) {
                this._fileChooserResult = new JFileChooser();
                FileFilterExtention altFilter = new FileFilterExtention("AltaRica file (*.alt)", ".alt").verifyWrite(true);
                this._fileChooserResult.addChoosableFileFilter(altFilter);
                this._fileChooserResult.setFileFilter(altFilter);
            }
            this._fileChooserResult.setCurrentDirectory(this._defPath);
            return this._fileChooserResult;
        }

        public DlgLaunch(Window win) {
            super(win);
            this.init();
        }

        @Override
        protected void init() {
            super.init();
            this.getContentPane().setLayout(new BorderLayout());
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._result = false;
            int line = 0;
            rPanel.add((Component)new JLabel(ResTrans.getString("DLG_PLUGTRANS_FILE")), new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this._ctrlPath = new JTextField(30);
            rPanel.add((Component)this._ctrlPath, new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            JButton bPath = new JButton("...");
            rPanel.add((Component)bPath, new GridBagConstraints(1, line++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DlgLaunch.this.getFCResult();
                    if (fc.showSaveDialog(DlgLaunch.this._ctrlPath) == 0) {
                        DlgLaunch.this._defPath = fc.getSelectedFile().getParentFile();
                        DlgLaunch.this._ctrlPath.setText(FileFilterExtention.addDefaultExtention(fc).getPath());
                    }
                }
            });
            JPanel oPanel = new JPanel(new GridBagLayout());
            oPanel.setBorder(BorderFactory.createTitledBorder(ResTrans.getString("DLG_PLUGTRANS_OPTIONS")));
            int oLine = 0;
            JLabel lbl = new JLabel(ResTrans.getString("DLG_PLUGTRANS_FORMAT"));
            oPanel.add((Component)lbl, new GridBagConstraints(0, oLine, 1, 1, 100.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this._ctrlFormats = new JComboBox();
            this._ctrlFormats.addItem(Format.DATAFLOW);
            this._ctrlFormats.addItem(Format.MOCARP);
            this._ctrlFormats.addItem(Format.MEC5);
            this._ctrlFormats.addItem(Format.OTOOLS);
            if (Boolean.getBoolean(PluginCmdTranslate.PROP_CMDTRANSLATE_OTOOLSFLATNESS)) {
                this._ctrlFormats.addItem(Format.OTOOLSF);
            }
            this._ctrlFormats.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = DlgLaunch.this.getFCResult();
                    FileFilter[] ffs = fc.getChoosableFileFilters();
                    Format frm = (Format)((Object)DlgLaunch.this._ctrlFormats.getSelectedItem());
                    FileFilterExtention newFilter = new FileFilterExtention(frm.getLabel(), frm.getExt()).verifyWrite(true);
                    if (ffs.length > 1 && ffs[1] instanceof FileFilterExtention) {
                        File file;
                        FileFilterExtention oldFilter = (FileFilterExtention)ffs[1];
                        String path = DlgLaunch.this._ctrlPath.getText().trim();
                        if (path.length() > 0 && oldFilter.verifyExtention(file = new File(path))) {
                            file = new File(oldFilter.removeDefaultExtention(file));
                            file = newFilter.addDefaultExtention(file);
                            DlgLaunch.this._ctrlPath.setText(file.getAbsolutePath());
                        }
                    }
                    fc.resetChoosableFileFilters();
                    fc.addChoosableFileFilter(newFilter);
                }
            });
            oPanel.add((Component)this._ctrlFormats, new GridBagConstraints(1, oLine++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlTrace = new JTextField(30);
            final JButton bPath2 = new JButton("...");
            this._ctrlTrace.setEnabled(false);
            this._ctrlTrace.setToolTipText(ResTrans.getString("DLG_PLUGTRANS_TRACE"));
            bPath2.setEnabled(false);
            this._ctrlRename = new JCheckBox(ResTrans.getString("DLG_PLUGTRANS_RENAME"));
            this._ctrlRename.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean enable = DlgLaunch.this._ctrlRename.isSelected();
                    DlgLaunch.this._ctrlTrace.setEnabled(enable);
                    bPath2.setEnabled(enable);
                }
            });
            oPanel.add((Component)this._ctrlRename, new GridBagConstraints(0, oLine++, 2, 1, 100.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            oPanel.add((Component)this._ctrlTrace, new GridBagConstraints(0, oLine, 1, 1, 100.0, 0.0, 17, 2, new Insets(5, 15, 5, 0), 0, 0));
            oPanel.add((Component)bPath2, new GridBagConstraints(1, oLine++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            bPath2.addActionListener(new ActionListener(){
                JFileChooser _fileChooserTrace;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this._fileChooserTrace == null) {
                        this._fileChooserTrace = new JFileChooser();
                        FileFilterExtention txtFilter = new FileFilterExtention("Text file (*.txt)", ".txt").verifyWrite(true);
                        this._fileChooserTrace.addChoosableFileFilter(txtFilter);
                        this._fileChooserTrace.setFileFilter(txtFilter);
                    }
                    this._fileChooserTrace.setCurrentDirectory(DlgLaunch.this._defPath);
                    if (this._fileChooserTrace.showSaveDialog(DlgLaunch.this._ctrlTrace) == 0) {
                        DlgLaunch.this._defPath = this._fileChooserTrace.getSelectedFile().getParentFile();
                        DlgLaunch.this._ctrlTrace.setText(FileFilterExtention.addDefaultExtention(this._fileChooserTrace).getPath());
                    }
                }
            });
            rPanel.add((Component)oPanel, new GridBagConstraints(0, line++, 2, 1, 100.0, 100.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, line++, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setResizable(true);
            this.setTitle(ResTrans.getString("PLUG_CMD_TRANSLATE_NAME"));
        }

        public boolean DoModal() {
            this._result = false;
            this.setModal(true);
            this.setVisible(true);
            return this._result;
        }

        @Override
        protected boolean verifyParameters() {
            String trace;
            String title = ResTrans.getString("DEF_TITLE");
            String path = this._ctrlPath.getText();
            if (!FileUtility.verifyPath((String)path, (boolean)true, (Component)this._ctrlPath, (String)title)) {
                return false;
            }
            return !this._ctrlRename.isSelected() || (trace = this._ctrlTrace.getText()).length() <= 0 || FileUtility.verifyPath((String)trace, (boolean)true, (Component)this._ctrlTrace, (String)title);
        }
    }

    static enum Format {
        DATAFLOW("DataFlow", ".alt", new TranslatePluginDataFlow()),
        MOCARP("MocaRP", ".mok", new TranslatePluginMocaRP()),
        MEC5("Mec5", ".alt", new TranslatePluginMec5()),
        OTOOLS("OTools", ".alt", new TranslatePluginOTools()),
        OTOOLSF("OToolsFlatness", ".alt", new TranslatePluginOToolsF());

        String _key;
        String _ext;
        PluginMTranslate _translate;

        private Format(String key, String ext, PluginMTranslate translate) {
            this._key = key;
            this._ext = ext;
            this._translate = translate;
        }

        public String getCode() {
            return this._key;
        }

        public String getExt() {
            return this._ext;
        }

        public String getLabel() {
            return this._key + " file (*" + this._ext + ")";
        }

        public PluginMTranslate getTranslate() {
            return this._translate;
        }

        public String toString() {
            return this._key;
        }
    }
}

