/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.AbstractPluginModelBan;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.destination.DestinationRecord;
import com.dassault.cecilia.plugin.mbsa.translator.BanTranslateHelper;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateOptions;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;

public abstract class PluginSimulTranslator
extends AbstractPluginModelBan {
    public static final String OPT_DETERMINIST = PluginSimulTranslator.class.getName() + "#Determinist";
    public static final String OPT_EXC_CONFLICT = PluginSimulTranslator.class.getName() + "#ExcConflict";
    public static final String OPT_FIXPOINT_LOOP_MAX = PluginSimulTranslator.class.getName() + "#FixPointLoopMax";

    @Override
    protected InputStream getStreamOfBanScript() {
        return this.getClass().getResourceAsStream(this.getNameOfBanScript());
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.default")) {
            return "true";
        }
        return super.getInfo(key);
    }

    @Override
    protected File getBanScript() {
        return null;
    }

    protected void prepareCompilBanEntry(Plugable launcher, IModel model, File resultFile, Object pluginParameters) {
        BanEntry ban = this.getBanEntry();
        ban.setUserProperty("altr.translate.ccf", Boolean.toString(TranslateOptions.withTranslateCCF(launcher)));
        ban.setUserProperty("altr.dataflow.verify", Boolean.toString(TranslateOptions.withDataFlowVerify(launcher)));
        ban.setUserProperty("altr.verify.before", TranslateOptions.listVerifyBefore(launcher, 2));
        ban.setUserProperty("altr.verify.after", TranslateOptions.listVerifyAfter(launcher, 2));
        ban.setUserProperty("altr.input", model.getFile().getAbsolutePath());
        ban.setUserProperty("altr.main", model.getName());
        ban.setUserProperty("altr.uid", Long.toString(model.getUID()));
        ban.setUserProperty("altr.stepper.file", resultFile.getAbsolutePath());
        ban.setUserProperty("altr.log.class", DestinationRecord.class.getName());
        ban.setUserProperty("altr.log.format", "txt");
        ban.setUserProperty("altr.log.opt.key", "Limit");
        ban.setUserProperty("altr.log.opt.val", "100");
        this.prepareSimulBanEntry(ban, launcher);
        if (pluginParameters != null && pluginParameters instanceof Map) {
            for (Map.Entry entryParam : ((Map)pluginParameters).entrySet()) {
                ban.setUserProperty(entryParam.getKey().toString(), entryParam.getValue().toString());
            }
        }
    }

    protected void prepareSimulBanEntry(BanEntry ban, Plugable launcher) {
        ban.setUserProperty("stepper.determinist.auto", Boolean.toString(PlugableUtility.getBoolOpt(launcher, OPT_DETERMINIST, false)));
        ban.setUserProperty("stepper.conflict.sheduler", Boolean.toString(PlugableUtility.getBoolOpt(launcher, OPT_EXC_CONFLICT, false)));
        String chgMax = PlugableUtility.getStrOpt(launcher, OPT_FIXPOINT_LOOP_MAX, "5");
        try {
            int value = Integer.parseInt(chgMax);
            if (value > 1000) {
                value = 1000;
            }
            if (value > 0) {
                ban.setUserProperty("stepper.fixpoint.loop", Integer.toString(value));
            }
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        ban.setUserProperty("stepper.instantaneous.auto", Boolean.toString(PlugableUtility.getBoolOpt(launcher, Stepper.OPTION_INSTANTANEOUS_AUTO, true)));
        String instLoop = PlugableUtility.getStrOpt(launcher, Stepper.OPTION_INSTANTANEOUS_LOOP, Integer.toString(100));
        try {
            int value = Integer.parseInt(instLoop);
            if (value > 0) {
                ban.setUserProperty("stepper.instantaneous.loop", Integer.toString(value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void catchProcessBanException(Plugable launcher, BanProcessException e, IModel model) {
        BanEntry ban = this.getBanEntry();
        Object logger = ban.getIdObject("altr-log-ref");
        if (logger != null && logger instanceof DestinationRecord) {
            DestinationRecord dest = (DestinationRecord)logger;
            if (dest != null && dest.getNbrRecord() > 0) {
                BanTranslateHelper.showParseError(launcher, model, dest.getRecords(), e.getMessage());
            } else {
                logger = null;
            }
        }
        if (logger == null) {
            super.catchBanException(launcher, e, new Object[0]);
        }
    }

    protected Stepper createCompiledStepper(Plugable launcher, File compil, Object parameters, IModel iModel) {
        try {
            this._ban = new BanEntry();
        }
        catch (BanLicenseException e) {
            this.showErrorMessage(launcher, "ERR_BAN_LICENSE", e, new Object[0]);
            return null;
        }
        try {
            this.prepareSimulBanEntry(this._ban, launcher);
            this._ban.setUserProperty("altr.stepper.file", compil.getAbsolutePath());
            this._ban.setUserProperty("altr.input", iModel.getFile().getAbsolutePath());
            this._ban.setUserProperty("altr.uid", Long.toString(iModel.getUID()));
            if (parameters instanceof Map) {
                for (Map.Entry param : ((Map)parameters).entrySet()) {
                    this._ban.setUserProperty(param.getKey().toString(), param.getValue().toString());
                }
            }
            String nameOfBanScript = this.getNameOfBanScriptCompiler();
            BanInputStream stream = new BanInputStream(this.getClass().getResourceAsStream(nameOfBanScript), nameOfBanScript);
            this._ban.execute(stream);
            return (Stepper)this._ban.getIdObject("stepper-id");
        }
        catch (BanProcessException e) {
            this.catchBanException(launcher, e, iModel);
        }
        catch (Throwable e) {
            this.showErrorMessage(launcher, "ERR_BAN_LAUNCH", e, new Object[0]);
            ResTrans.LOG.log(Level.INFO, "Exception during create compil stepper", e);
        }
        return null;
    }

    protected String getNameOfBanScriptCompiler() {
        return "BanScriptCompiler.xml";
    }
}

