/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.translator.model.LineCorrespondence;
import com.dassault.cecilia.lib.util.destination.DestinationRecord;
import com.dassault.cecilia.plugin.mbsa.translator.BanTranslateHelper;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateParameters;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.xml.sax.Locator;

public class TranslateGeneric
extends BanTranslateHelper
implements Translator {
    protected PluginMTranslate _owner;
    protected TranslateParameters _params;
    protected boolean _displayError;
    LineCorrespondence _lineTrf;

    public TranslateGeneric(Plugable launcher, PluginMTranslate owner, TranslateParameters params) {
        super(launcher);
        this._owner = owner;
        this._params = new TranslateParameters(params);
        this._displayError = true;
        this._lineTrf = null;
    }

    @Override
    protected void showParseError(List<String> msgs, String title) {
        if (!this._displayError) {
            return;
        }
        super.showParseError(msgs, title);
    }

    @Override
    protected void showErrorMessage(String key, Throwable e, Object ... objects) {
        if (!this._displayError) {
            return;
        }
        super.showErrorMessage(key, e, objects);
    }

    @Override
    public IModel getSourceModel() {
        return this._model;
    }

    @Override
    public boolean translate(File output, boolean displayError) {
        boolean result = false;
        this._displayError = displayError;
        this._lineTrf = null;
        this._model = this._launcher.getModel("altarica.file");
        if (this._model != null) {
            try {
                this._ban = new BanEntry();
                for (Map.Entry<String, String> opt : this._params.getOpts().entrySet()) {
                    this._ban.setUserProperty(opt.getKey(), opt.getValue());
                }
                this._ban.setUserProperty("altr.input", this._model.getFile().getAbsolutePath());
                this._ban.setUserProperty("altr.main", this._model.getName());
                this._ban.setUserProperty("altr.uid", Long.toString(this._model.getUID()));
                this._ban.setUserProperty("altr.output", output.getAbsolutePath());
                this._ban.setUserProperty("altr.format", this._params.getFormat());
                this._ban.setUserProperty("altr.log.class", DestinationRecord.class.getName());
                this._ban.setUserProperty("altr.log.format", "txt");
                this._ban.setUserProperty("altr.log.opt.key", "Limit");
                this._ban.setUserProperty("altr.log.opt.val", "100");
                String name = "BanScriptTranslate.xml";
                BanInputStream inputStream = new BanInputStream(this.getClass().getResourceAsStream(name), name);
                this._ban.execute(inputStream);
                result = true;
            }
            catch (BanProcessException e) {
                Object obj = this._ban.getIdObject("altr-log-ref");
                if (obj != null) {
                    DestinationRecord dest = (DestinationRecord)obj;
                    if (dest != null && dest.getNbrRecord() > 0) {
                        this.showParseError(dest.getRecords(), e.getMessage());
                    } else {
                        obj = null;
                    }
                }
                if (obj == null) {
                    Locator loc;
                    Throwable exc = e;
                    if (e.getException() != null) {
                        exc = e.getException();
                    }
                    if ((loc = e.getLocator()) != null) {
                        this.showErrorMessage("TRANS_ERROR_BAN", exc, "[Debug info : " + loc.getLineNumber() + "]");
                    } else {
                        this.showErrorMessage("TRANS_ERROR_BAN", exc, new Object[0]);
                    }
                }
            }
            catch (BanLicenseException e) {
                this.showErrorMessage("TRANS_ERROR_LICENSE", e, new Object[0]);
            }
            catch (Throwable e) {
                this.showErrorMessage("TRANS_ERROR_BAN", e, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public boolean displayOriginalLine(int translateLine, String message, String title) {
        return this._lineTrf != null;
    }
}

