/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.StringMapTableModel;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateParametersIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class TranslateParameters {
    String _format;
    Map<String, String> _opts;
    protected static IOParameters _instance = null;

    public String getFormat() {
        return this._format;
    }

    protected void setFormat(String value) {
        this._format = value;
    }

    public Map<String, String> getOpts() {
        return this._opts;
    }

    public String getOpt(String key) {
        return this._opts.get(key);
    }

    protected void addOpt(String key, String value) {
        this._opts.put(key, value);
    }

    public TranslateParameters() {
        this._format = "undef";
        this._opts = null;
    }

    public TranslateParameters(String frm, Map<String, String> opts) {
        this._format = frm;
        this._opts = opts;
    }

    public TranslateParameters(TranslateParameters src) {
        if (src != null) {
            this._format = src._format;
            this._opts = new HashMap<String, String>(src._opts);
        }
    }

    public boolean change(PluginManager parent, String[] formats, String[] cmds) {
        Window win = SwingUtilities.getWindowAncestor(parent.getWindow());
        if (win == null) {
            win = parent.getWindow();
        }
        DlgChange dlg = new DlgChange(win);
        dlg.setFormat(formats, this._format);
        dlg.setParameters(this._opts);
        if (dlg.DoModal()) {
            this._format = dlg.getFormat();
            this._opts = dlg.getParameters();
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        if (_instance == null) {
            _instance = new TranslateParametersIO();
        }
        return _instance;
    }

    class DlgChange
    extends JDialogCecilia {
        JComboBox _ctrlFormats;
        StringMapTableModel _modelParameters;
        JTable _ctrlParameters;
        TableCellEditor _editParameters;
        JButton _ctrlAdd;
        JButton _ctrlDel;
        JButton _ctrlUp;
        JButton _ctrlDown;

        public DlgChange(Window win) {
            super(win);
            this.init();
        }

        @Override
        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new BorderLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._result = false;
            JPanel fPanel = new JPanel(new GridLayout(1, 2, 5, 5));
            fPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            fPanel.add(new JLabel(ResTrans.getString("DLG_PARAMS_FORMAT")));
            this._ctrlFormats = new JComboBox();
            this._ctrlFormats.setLightWeightPopupEnabled(false);
            fPanel.add(this._ctrlFormats);
            rPanel.add((Component)fPanel, "North");
            this._modelParameters = new StringMapTableModel();
            this._modelParameters.setData(TranslateParameters.this._opts);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResTrans.getString("DLG_PARAMS_PARAMS")));
            JPanel aPanel = new JPanel(new FlowLayout(2, 2, 5));
            this._ctrlAdd = new JButton(ResIcoCore.getImageIcon("BUT_ADD"));
            this._ctrlAdd.setBorder(BorderFactory.createEmptyBorder());
            this._ctrlAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = DlgChange.this._ctrlParameters.getSelectedRow();
                    if (idx == -1) {
                        DlgChange.this._modelParameters.addData("", "");
                        idx = DlgChange.this._modelParameters.getRowCount() - 1;
                    } else {
                        DlgChange.this._modelParameters.insertData("", "", idx);
                    }
                    DlgChange.this._ctrlParameters.editCellAt(idx, 0);
                    DlgChange.this.refreshCtrl();
                }
            });
            aPanel.add(this._ctrlAdd);
            this._ctrlDel = new JButton(ResIcoCore.getImageIcon("BUT_DEL"));
            this._ctrlDel.setBorder(BorderFactory.createEmptyBorder());
            this._ctrlDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = DlgChange.this._ctrlParameters.getSelectedRow();
                    if (idx != -1) {
                        DlgChange.this._editParameters.cancelCellEditing();
                        DlgChange.this._modelParameters.removeData(idx);
                        DlgChange.this.refreshCtrl();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            });
            aPanel.add(this._ctrlDel);
            this._ctrlUp = new JButton(ResIcoCore.getImageIcon("BUT_UP"));
            this._ctrlUp.setBorder(BorderFactory.createEmptyBorder());
            this._ctrlUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = DlgChange.this._ctrlParameters.getSelectedRow();
                    if (idx != -1 && idx > 0) {
                        DlgChange.this._editParameters.cancelCellEditing();
                        DlgChange.this._modelParameters.down(idx);
                        DlgChange.this._ctrlParameters.setRowSelectionInterval(idx - 1, idx - 1);
                        DlgChange.this.refreshCtrl();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            });
            aPanel.add(this._ctrlUp);
            this._ctrlDown = new JButton(ResIcoCore.getImageIcon("BUT_DOWN"));
            this._ctrlDown.setBorder(BorderFactory.createEmptyBorder());
            this._ctrlDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = DlgChange.this._ctrlParameters.getSelectedRow();
                    if (idx != -1 && idx < DlgChange.this._modelParameters.getRowCount() - 1) {
                        DlgChange.this._editParameters.cancelCellEditing();
                        DlgChange.this._modelParameters.up(idx);
                        DlgChange.this._ctrlParameters.setRowSelectionInterval(idx + 1, idx + 1);
                        DlgChange.this.refreshCtrl();
                    } else {
                        LogUtility.logStackTrace((Logger)LogUtility.getLog(TranslateParameters.class), (Level)Level.FINER, (String)"idx no correct");
                    }
                }
            });
            aPanel.add(this._ctrlDown);
            pPanel.add((Component)aPanel, "North");
            this._ctrlParameters = new JTable(this._modelParameters);
            this._ctrlParameters.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            ListSelectionModel selMod = this._ctrlParameters.getSelectionModel();
            selMod.setSelectionMode(0);
            selMod.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DlgChange.this.refreshCtrl();
                }
            });
            this._editParameters = this._ctrlParameters.getDefaultEditor(String.class);
            JPanel tPanel = new JPanel(new BorderLayout());
            tPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.black)));
            tPanel.add(this._ctrlParameters);
            pPanel.add((Component)tPanel, "Center");
            rPanel.add((Component)pPanel, "Center");
            rPanel.add((Component)this.createButPanel(), "South");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            tSize.height += 100;
            tSize.width += 50;
            this.setSize(tSize);
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResTrans.getString("DEF_TITLE"));
        }

        public void setFormat(String[] formats, String current) {
            int idx = -1;
            for (int i = 0; i < formats.length; ++i) {
                if (current.equals(formats[i])) {
                    idx = i;
                }
                this._ctrlFormats.addItem(formats[i]);
            }
            if (idx == -1) {
                idx = this._ctrlFormats.getItemCount();
                this._ctrlFormats.addItem(current);
            }
            this._ctrlFormats.setSelectedIndex(idx);
        }

        public void setParameters(Map<String, String> params) {
            this._modelParameters.setData(params);
        }

        public String getFormat() {
            return (String)this._ctrlFormats.getSelectedItem();
        }

        public Map<String, String> getParameters() {
            return this._modelParameters.getData();
        }

        public boolean DoModal() {
            this._result = false;
            this.setModal(true);
            this.setVisible(true);
            return this._result;
        }

        @Override
        protected boolean verifyParameters() {
            List<String> params = this._modelParameters.getKeys();
            for (int i = 0; i < params.size(); ++i) {
                String txt = params.get(i);
                if (txt != null && txt.length() != 0) continue;
                this._ctrlParameters.setRowSelectionInterval(i, i);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResTrans.getString("DLG_PARAMS_PARAMS_ERROR"));
                return false;
            }
            return true;
        }

        protected void refreshCtrl() {
            int idx = this._ctrlParameters.getSelectedRow();
            this._ctrlDel.setEnabled(idx != -1);
            this._ctrlUp.setEnabled(idx != -1 && idx > 0);
            this._ctrlDown.setEnabled(idx != -1 && idx < this._ctrlParameters.getRowCount() - 1);
        }
    }
}

