/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.translator;

import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.translator.ResTrans;
import com.dassault.cecilia.plugin.mbsa.translator.TranslateParameters;
import com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginFormat;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TranslatePluginJarByteCode
extends TranslatePluginFormat
implements PluginMTranslate {
    private static Logger _LOG = Logger.getLogger(TranslatePluginJarByteCode.class.getPackage().getName());
    private JavacOptsPanel _javacOpts = null;
    private boolean _changeOptions = true;
    public static final String OPT_JPATH = TranslatePluginJarByteCode.class.getName() + "#Javac.Path";
    public static final String OPT_JBIN = TranslatePluginJarByteCode.class.getName() + "#Javac.Bin";
    public static final String OPT_JOPTS = TranslatePluginJarByteCode.class.getName() + "#Javac.Opts";
    public static final String OPT_JBIN_DEFAULT = "javac";
    public static final String OPT_JOPTS_DEFAULT = "-nowarn -source 1.8 -target 1.8";
    private boolean _verifyJavac = false;

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        if (this._javacOpts == null) {
            this._javacOpts = new JavacOptsPanel();
        }
        this._javacOpts.prepareWith(launcher);
        return this._javacOpts;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        if (this._javacOpts != null) {
            this._javacOpts.prepareWith(launcher);
        }
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResTrans.getString("PLUG_TRANS_JARBYTE_NAME");
        }
        if (key.equals("plugin.description")) {
            return ResTrans.getString("PLUG_TRANS_JARBYTE_DESC");
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A1-07.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    protected void prepareParameters(Plugable launcher, TranslateParameters params) {
        super.prepareParameters(launcher, params);
        params.setFormat("Java1");
        Object path = PlugableUtility.getStrOpt(launcher, OPT_JPATH, "");
        if (((String)path).length() > 0) {
            switch (((String)path).charAt(((String)path).length() - 1)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    path = (String)path + System.getProperty("file.separator");
                }
            }
        }
        params.addOpt("altr.javac.path", (String)path);
        params.addOpt("altr.javac.bin", PlugableUtility.getStrOpt(launcher, OPT_JBIN, OPT_JBIN_DEFAULT));
        params.addOpt("altr.javac.options", PlugableUtility.getStrOpt(launcher, OPT_JOPTS, OPT_JOPTS_DEFAULT));
        params.addOpt("altr.jstepper.version", "7.00.0");
    }

    @Override
    public Translator createTranslator(Plugable launcher, Object params) {
        if (!this.verifyJavaCompiler(launcher)) {
            return null;
        }
        return super.createTranslator(launcher, params);
    }

    private synchronized boolean verifyJavaCompiler(Plugable launcher) {
        if (!this._changeOptions) {
            return this._verifyJavac;
        }
        this._changeOptions = false;
        this._verifyJavac = false;
        StringBuilder sb = new StringBuilder();
        sb.append(PlugableUtility.getStrOpt(launcher, OPT_JPATH, ""));
        if (sb.length() > 0) {
            switch (sb.charAt(sb.length() - 1)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    sb.append(System.getProperty("file.separator"));
                }
            }
        }
        sb.append(PlugableUtility.getStrOpt(launcher, OPT_JBIN, OPT_JBIN_DEFAULT));
        sb.append(" -version");
        try {
            Process process = Runtime.getRuntime().exec(sb.toString());
            process.waitFor(1L, TimeUnit.SECONDS);
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                _LOG.fine("Java compiler path : " + sb.toString());
                _LOG.warning("Java compiler return bad error : " + exitValue);
            } else {
                this._verifyJavac = true;
            }
        }
        catch (Exception e) {
            _LOG.fine("Java compiler path : " + sb.toString());
        }
        return this._verifyJavac;
    }

    class JavacOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JTextField _ctrlPath;
        JTextField _ctrlBin;
        JTextField _ctrlOpts;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlPath.setText(PlugableUtility.getStrOpt(this._launcher, OPT_JPATH, ""));
            this._ctrlBin.setText(PlugableUtility.getStrOpt(this._launcher, OPT_JBIN, TranslatePluginJarByteCode.OPT_JBIN_DEFAULT));
            this._ctrlOpts.setText(PlugableUtility.getStrOpt(this._launcher, OPT_JOPTS, TranslatePluginJarByteCode.OPT_JOPTS_DEFAULT));
        }

        public JavacOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.insets.top = 10;
            gbc.insets.bottom = 10;
            gbc.insets.right = 10;
            gbc.insets.left = 10;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            root.setBorder(BorderFactory.createTitledBorder(ResTrans.getString("DLG_OPT_JAVAC")));
            gbc.fill = 0;
            gbc.gridx = 0;
            gbc.gridy = -1;
            ++gbc.gridy;
            root.add((Component)new JLabel(ResTrans.getString("DLG_OPT_JAVAC_PATH")), gbc);
            ++gbc.gridy;
            root.add((Component)new JLabel(ResTrans.getString("DLG_OPT_JAVAC_BIN")), gbc);
            ++gbc.gridy;
            root.add((Component)new JLabel(ResTrans.getString("DLG_OPT_JAVAC_OPTS")), gbc);
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = -1;
            ++gbc.gridy;
            this._ctrlPath = new JTextField(20);
            root.add((Component)this._ctrlPath, gbc);
            ++gbc.gridy;
            this._ctrlBin = new JTextField(20);
            root.add((Component)this._ctrlBin, gbc);
            ++gbc.gridy;
            this._ctrlOpts = new JTextField(20);
            root.add((Component)this._ctrlOpts, gbc);
            gbc.fill = 0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            JButton defVal = new JButton(ResTrans.getString("DLG_DEFVALUE"));
            defVal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavacOptsPanel.this._ctrlPath.setText("");
                    JavacOptsPanel.this._launcher.setOption(OPT_JPATH, JavacOptsPanel.this._ctrlPath.getText());
                    JavacOptsPanel.this._ctrlBin.setText(TranslatePluginJarByteCode.OPT_JBIN_DEFAULT);
                    JavacOptsPanel.this._launcher.setOption(OPT_JBIN, TranslatePluginJarByteCode.OPT_JBIN_DEFAULT);
                    JavacOptsPanel.this._ctrlOpts.setText(TranslatePluginJarByteCode.OPT_JOPTS_DEFAULT);
                    JavacOptsPanel.this._launcher.setOption(OPT_JOPTS, TranslatePluginJarByteCode.OPT_JOPTS_DEFAULT);
                    TranslatePluginJarByteCode.this._changeOptions = true;
                }
            });
            root.add((Component)defVal, gbc);
            this._ctrlPath.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        JavacOptsPanel.this._launcher.setOption(OPT_JPATH, JavacOptsPanel.this._ctrlPath.getText());
                        TranslatePluginJarByteCode.this._changeOptions = true;
                    }
                }
            });
            this._ctrlBin.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        JavacOptsPanel.this._launcher.setOption(OPT_JBIN, JavacOptsPanel.this._ctrlBin.getText());
                        TranslatePluginJarByteCode.this._changeOptions = true;
                    }
                }
            });
            this._ctrlOpts.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!e.isTemporary()) {
                        JavacOptsPanel.this._launcher.setOption(OPT_JOPTS, JavacOptsPanel.this._ctrlOpts.getText());
                        TranslatePluginJarByteCode.this._changeOptions = true;
                    }
                }
            });
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void trash() {
        }

        @Override
        public String getInfo(String key) {
            return TranslatePluginJarByteCode.this.getInfo(key);
        }

        @Override
        public Icon getIcon(String key) {
            return null;
        }
    }
}

