/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class EditorFilePath
extends DefaultTableCellRenderer
implements TableCellEditor {
    TargetModel _tgt;
    JTable _lastTable;
    JFileChooser _dlgFile;
    private EventListenerList _listeners = new EventListenerList();
    private ChangeEvent _evt = new ChangeEvent(this);

    protected void createFileChooser() {
        if (this._dlgFile == null) {
            this._dlgFile = new JFileChooser();
            this._dlgFile.setFileSelectionMode(0);
        }
        this._dlgFile.setCurrentDirectory(new File(PlugableUtility.getStrOpt(this._tgt.getPlugable(), "plugable.option.path", ".")));
        this._dlgFile.setFileFilter(this._tgt.getFilter());
    }

    public EditorFilePath(TargetModel tgt) {
        this._tgt = tgt;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.createFileChooser();
        String path = (String)value;
        if (path != null && path.length() > 0) {
            this._dlgFile.setSelectedFile(new File(path));
        } else {
            this._dlgFile.setSelectedFile(new File(""));
        }
        this._lastTable = table;
        Rectangle rect = table.getCellRect(row, column, false);
        Point pt = new Point(rect.x, rect.y);
        SwingUtilities.convertPointToScreen(pt, table);
        Dimension size = this._dlgFile.getSize();
        this._dlgFile.setLocation(pt.x + (rect.width - size.width) / 2, pt.y + (rect.height - size.height) / 2);
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._dlgFile != null) {
            File select = this._dlgFile.getSelectedFile();
            if (!this._tgt.getFilter().accept(select)) {
                return select.getAbsolutePath() + this._tgt.getFilter().getDefaultExtension();
            }
            this._tgt.getPlugable().setOption("plugable.option.path", select.getParent());
            return select.getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= 2;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditorFilePath.this._dlgFile.showSaveDialog(EditorFilePath.this._lastTable) == 0) {
                    EditorFilePath.this.fireEditionStopped();
                } else {
                    EditorFilePath.this.fireEditionCanceled();
                }
            }
        });
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this._listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this._listeners.remove(CellEditorListener.class, l);
    }

    protected void fireEditionStopped() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingStopped(this._evt);
        }
    }

    protected void fireEditionCanceled() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingCanceled(this._evt);
        }
    }
}

