/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewDomain;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewValue;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.cecilia.stepper.view.TreeModelNode;
import com.dassault.cecilia.core.cecilia.stepper.view.TreeRenderedNode;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;

public class EditorVariableViewer
extends DefaultTableCellRenderer
implements TableCellEditor {
    ViewStepper _stepper;
    DlgFlowViewer _dlg = null;
    private EventListenerList _listeners = new EventListenerList();
    private ChangeEvent _evt = new ChangeEvent(this);

    public EditorVariableViewer(ViewStepper stepper) {
        this._stepper = stepper;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this._dlg == null) {
            Window win = SwingUtilities.getWindowAncestor(table);
            this._dlg = new DlgFlowViewer(win);
        }
        this._dlg._select = (TargetValue)value;
        this._dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(table));
        Point pt = this._dlg.getLocation();
        pt.x += 30;
        this._dlg.setLocation(pt);
        JOptionCecilia.ensureDialogIsIntoScreen(this._dlg);
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public void cancelCellEditing() {
        if (this._dlg != null) {
            this._dlg.setVisible(false);
        }
    }

    @Override
    public boolean stopCellEditing() {
        if (this._dlg != null) {
            this._dlg.setVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._dlg != null) {
            return this._dlg._select;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() >= 2;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditorVariableViewer.this._dlg.DoModal()) {
                    EditorVariableViewer.this.fireEditionStopped();
                } else {
                    EditorVariableViewer.this.fireEditionCanceled();
                }
            }
        });
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this._listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this._listeners.remove(CellEditorListener.class, l);
    }

    protected void fireEditionStopped() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingStopped(this._evt);
        }
    }

    protected void fireEditionCanceled() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingCanceled(this._evt);
        }
    }

    class DlgFlowViewer
    extends JDialogCecilia {
        private JTree _ctrlTree;
        private TreeModelNode _docTree;
        protected TargetValue _select;

        DlgFlowViewer(Window win) {
            super(win);
            this.init();
        }

        @Override
        protected void init() {
            super.init();
            this.setTitle(ResViewer.getString("EDIT_TGT_SEL_TITLE"));
            this.getContentPane().setLayout(new BorderLayout());
            this._docTree = new TreeModelNode(ViewVariable.class, false);
            this._docTree.setStepper(EditorVariableViewer.this._stepper);
            EditorVariableViewer.this._stepper.addAltaListener(this._docTree);
            this._ctrlTree = new JTree(this._docTree);
            this._ctrlTree.setRootVisible(true);
            TreeRenderedNode rendered = new TreeRenderedNode();
            this._ctrlTree.setCellRenderer(rendered);
            this.getContentPane().add((Component)new JScrollPane(this._ctrlTree), "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this._ctrlTree.getSelectionModel().setSelectionMode(1);
            this._ctrlTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath tpath = DlgFlowViewer.this._ctrlTree.getSelectionPath();
                    if (tpath == null) {
                        DlgFlowViewer.this._select = null;
                    } else if (tpath.getLastPathComponent() instanceof ViewValue) {
                        StringBuffer var = new StringBuffer();
                        String val = tpath.getLastPathComponent().toString();
                        Object[] path = tpath.getPath();
                        for (int i = 1; i < path.length - 1; ++i) {
                            if (i > 1) {
                                var.append(".");
                            }
                            var.append(path[i].toString());
                        }
                        DlgFlowViewer.this._select = new TargetValue(var.toString(), val);
                    } else {
                        DlgFlowViewer.this._select = null;
                    }
                    DlgFlowViewer.this._ctrlOK.setEnabled(DlgFlowViewer.this._select != null);
                }
            });
            this._ctrlTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    TreePath tpath = DlgFlowViewer.this._ctrlTree.getSelectionPath();
                    if (tpath == null) {
                        return;
                    }
                    if (tpath.getLastPathComponent() instanceof ViewValue) {
                        DlgFlowViewer.this.validDialog();
                    }
                }
            });
            this._ctrlTree.setRowHeight(ResIcoAbstract.getIconSize());
            this.pack();
            Dimension size = this.getSize();
            size.width += 50;
            size.height += 50;
            this.setSize(size);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean verifyParameters() {
            boolean error = true;
            if (this._select == null || this._select.getValue() == null || this._select.getValue().length() == 0 || this._select.getPath() == null || this._select.getPath().length() == 0) {
                assert (false) : "_select not correct define";
            } else {
                ViewData data = this._docTree.getViewRoot().getData(this._select.getPath(), true);
                if (data == null || !(data instanceof ViewVariable)) {
                    assert (false) : "_select._path not variable";
                } else {
                    if (this._select.getValue().charAt(0) != '[') return true;
                    String value = JOptionPane.showInputDialog(JOptionCecilia.getTopContainerOf(this._ctrlOK), (Object)ResViewer.msgFormat("EDIT_TGT_SEL_INPUT", this._select.getPath()));
                    if (value != null) {
                        ViewDomain dom = ((ViewVariable)data).getDomain(this._docTree.getViewRoot());
                        ViewValue vv = dom.verifyValue(value);
                        if (vv == null) {
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlOK), ResViewer.msgFormat("EDIT_TGT_SEL_INPUT_ERROR", this._select.getPath(), value));
                        } else {
                            this._select.setValue(value);
                            return true;
                        }
                    }
                }
            }
            if (error) {
                LogUtility.logStackTrace((Logger)LogUtility.getLog(EditorVariableViewer.class), (Level)Level.INFO, (String)"Error for validation of EditorFlowViewer");
            }
            if (error) return false;
            return true;
        }

        boolean DoModal() {
            this._result = false;
            if (this._select != null) {
                if (this._select.getPath() == null || this._select.getValue() == null) {
                    this._select = null;
                    this._ctrlOK.setEnabled(false);
                } else {
                    TargetValue select = this._select;
                    this._select = null;
                    ViewData data = this._docTree.getViewRoot().getData(select.getPath(), true);
                    if (data != null && data instanceof ViewVariable) {
                        TreePath tpath = data.getTreePath();
                        this._ctrlTree.scrollPathToVisible(tpath);
                        this._ctrlTree.setSelectionPath(tpath);
                        ViewDomain dom = ((ViewVariable)data).getDomain(this._docTree.getViewRoot());
                        ViewValue vv = dom.verifyValue(select.getValue());
                        if (vv != null) {
                            tpath = tpath.pathByAddingChild(vv);
                            this._ctrlTree.scrollPathToVisible(tpath);
                        }
                        this._ctrlTree.setSelectionPath(tpath);
                    }
                }
            }
            this.setModal(true);
            this.setVisible(true);
            return this._result;
        }
    }
}

