/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.viewer;

import com.dassault.cecilia.core.cecilia.stepper.ViewData;
import com.dassault.cecilia.core.cecilia.stepper.ViewFlow;
import com.dassault.cecilia.core.cecilia.stepper.ViewState;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.cecilia.stepper.view.TreeRenderedNode;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.viewer.ResViewer;
import com.dassault.cecilia.plugin.mbsa.viewer.ViewTreeModelNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class PanelStepperViewer
extends JPanel
implements PlugPanel {
    private JTree _ctrlTree;
    private ViewTreeModelNode _docTree;
    private JComboBox _ctrlType;
    private JCheckBox _ctrlDom;
    private ViewStepper _stepper = new ViewStepper();
    private JFrame _owner = null;
    protected static final ItemFilter FILTER_ALL = new ItemFilter("PAN_STEP_FILTER_ALL");
    protected static final ItemFilter FILTER_TR = new ItemFilter("PAN_STEP_FILTER_TR");
    protected static final ItemFilter FILTER_VAR = new ItemFilter("PAN_STEP_FILTER_VAR");
    protected static final ItemFilter FILTER_FL = new ItemFilter("PAN_STEP_FILTER_FL");
    protected static final ItemFilter FILTER_ST = new ItemFilter("PAN_STEP_FILTER_ST");

    public PanelStepperViewer(Stepper stepper) throws StepperException {
        super(new BorderLayout());
        this.initialize();
        this._stepper.open(stepper);
    }

    @Override
    public void trash() {
        this._stepper.close();
        this._stepper = null;
        System.gc();
    }

    protected JFrame getOwner() {
        if (this._owner == null) {
            this._owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        }
        return this._owner;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this._docTree = new ViewTreeModelNode();
        this._stepper.addAltaListener(this._docTree);
        this._ctrlTree = new JTree(this._docTree);
        TreeRenderedNode rendered = new TreeRenderedNode();
        this._ctrlTree.setCellRenderer(rendered);
        this._ctrlTree.setRowHeight(ResIcoAbstract.getIconSize());
        this.add((Component)new JScrollPane(this._ctrlTree), "Center");
        JPanel north = new JPanel();
        JLabel lbl = new JLabel(ResViewer.getString("PAN_STEP_FILTER"));
        north.add(lbl);
        this._ctrlType = new JComboBox();
        this._ctrlType.addItem(FILTER_ALL);
        this._ctrlType.addItem(FILTER_TR);
        this._ctrlType.addItem(FILTER_VAR);
        this._ctrlType.addItem(FILTER_FL);
        this._ctrlType.addItem(FILTER_ST);
        this._ctrlType.setEditable(false);
        this._ctrlType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFilter sel = (ItemFilter)PanelStepperViewer.this._ctrlType.getSelectedItem();
                if (sel == FILTER_ALL) {
                    PanelStepperViewer.this._docTree.setType(ViewData.class);
                } else if (sel == FILTER_TR) {
                    PanelStepperViewer.this._docTree.setType(ViewTransition.class);
                } else if (sel == FILTER_VAR) {
                    PanelStepperViewer.this._docTree.setType(ViewVariable.class);
                } else if (sel == FILTER_FL) {
                    PanelStepperViewer.this._docTree.setType(ViewFlow.class);
                } else if (sel == FILTER_ST) {
                    PanelStepperViewer.this._docTree.setType(ViewState.class);
                }
            }
        });
        north.add(this._ctrlType);
        this._ctrlDom = new JCheckBox(ResViewer.getString("PAN_STEP_DOMAIN"));
        if (this._docTree.getViewRoot() != null) {
            this._ctrlDom.setSelected(this._docTree.getViewRoot().withDomain());
        }
        this._ctrlDom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelStepperViewer.this._docTree.getViewRoot() == null) {
                    return;
                }
                PanelStepperViewer.this._docTree.getViewRoot().setWithDomain(PanelStepperViewer.this._ctrlDom.isSelected());
                PanelStepperViewer.this._docTree.fireStructureChanged();
            }
        });
        north.add(this._ctrlDom);
        this.add((Component)north, "North");
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return ResViewer.getString("PAN_STEP_TITLE");
        }
        if (key.equals("ppanel.default.width")) {
            return "400";
        }
        if (key.equals("ppanel.default.height")) {
            return "600";
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoAbstract.getIconRes((URL)this.getClass().getResource("A4-06.svg"));
        }
        return null;
    }

    static class ItemFilter {
        String _key;

        ItemFilter(String key) {
            this._key = key;
        }

        public String toString() {
            return ResViewer.getString(this._key);
        }
    }
}

