/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import com.dassault.cecilia.lib.mcs.Cut;
import com.dassault.cecilia.lib.mcs.CutUser;
import com.dassault.cecilia.lib.mcs.McsUser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;

public class CutSet
implements McsUser {
    ArrayList<Cut> _cuts;
    String _top;

    @Override
    public void beginSet() throws IOException {
        this._cuts = new ArrayList();
        this._top = null;
    }

    @Override
    public void setTop(String top) {
        this._top = top;
    }

    @Override
    public void addCut(CutUser cutUser) throws IOException {
        Cut cut = (Cut)cutUser;
        cut.sort();
        this._cuts.add(cut);
        cut.setNum(this._cuts.size());
    }

    @Override
    public void endSet() throws IOException {
        Collections.sort(this._cuts);
        ArrayList<Cut> cuts = new ArrayList<Cut>(this._cuts.size());
        Cut prev = null;
        for (Cut cur : this._cuts) {
            if (prev != null) {
                if (prev.compareTo(cur) != 0) {
                    cuts.add(cur);
                }
            } else {
                cuts.add(cur);
            }
            prev = cur;
        }
        this._cuts = cuts;
    }

    public int size() {
        return this._cuts == null ? 0 : this._cuts.size();
    }

    public Cut getCut(int idx) {
        return this._cuts.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMcs(File output) {
        Writer out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(output));
            out.write("products(SortMCS(");
            out.write(this._top);
            out.write(")) = \n");
            for (i = 0; i < this._cuts.size(); ++i) {
                Cut cut = this._cuts.get(i);
                out.write("{");
                for (int j = 0; j < cut._evts.size(); ++j) {
                    if (j > 0) {
                        out.write(", ");
                    }
                    out.write(cut._evts.get(j));
                }
                out.write("}\n");
            }
            out.write("end");
            i = 1;
            return i != 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean writeDag(File output) {
        return this.writeDag(output, 100, '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDag(File output, int size, char sep) {
        Writer out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(output));
            this.writeLot(out, size, sep, this._top, 1, this._cuts.size());
            for (i = 0; i < this._cuts.size(); ++i) {
                Cut cut = this._cuts.get(i);
                out.write("g");
                out.write(sep);
                out.write(i);
                out.write(" := (");
                for (int j = 0; j < cut._evts.size(); ++j) {
                    if (j > 0) {
                        out.write(" & ");
                    }
                    out.write(cut._evts.get(j));
                }
                out.write(");\n");
            }
            i = 1;
            return i != 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void writeLot(Writer out, int len, char sep, String id, int min, int max) throws IOException {
        int nbr = max - min + 1;
        if (nbr > len) {
            int i;
            int size = nbr / len + (nbr % len == 0 ? 0 : 1);
            out.write(id);
            out.write(" := (");
            for (i = 0; i < size; ++i) {
                if (i > 0) {
                    out.write(" | ");
                }
                out.write(id);
                out.write(sep);
                out.write(i);
            }
            out.write(");\n");
            for (i = 0; i < size; ++i) {
                this.writeLot(out, len, sep, id + sep + i, min + i * len, i == size - 1 ? max : min + (i + 1) * len);
            }
        } else {
            out.write(id);
            out.write(" := (");
            for (int i = min; i <= max; ++i) {
                if (i > min) {
                    out.write(" | ");
                }
                out.write("g");
                out.write(sep);
                out.write(i);
            }
            out.write(");\n");
        }
    }
}

