/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import com.dassault.cecilia.lib.mcs.Cut;
import com.dassault.cecilia.lib.mcs.CutSet;
import com.dassault.cecilia.lib.mcs.McsReader;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.diff.Diff;
import com.dassault.cecilia.lib.util.diff.DiffLayoutSimple;
import com.dassault.cecilia.lib.util.diff.DiffRecDefine;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class McsDiff
extends Diff {
    File _file1;
    File _file2;
    String _ext1;
    String _ext2;
    CutSet _cuts1;
    CutSet _cuts2;

    public McsDiff(File file1, File file2) {
        this(file1, null, file2, null);
    }

    public McsDiff(File file1, String ext1, File file2, String ext2) {
        this._file1 = file1;
        this._file2 = file2;
        this._ext1 = ext1;
        this._ext2 = ext2;
        this._cuts1 = new CutSet();
        this._cuts2 = new CutSet();
        StringBuffer sb = new StringBuffer(32);
        sb.append("Diff MCS");
        DiffRecDefine define = new DiffRecDefine(sb.toString());
        define.setDesc1(file1).setDesc2(file2);
        this.setDefine(define);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action() throws IOException {
        try {
            McsReader reader = new McsReader(this._cuts1);
            reader.readXxx(this._file1, this._ext1);
            reader = new McsReader(this._cuts2);
            reader.readXxx(this._file2, this._ext2);
            int siz1 = this._cuts1.size();
            int siz2 = this._cuts2.size();
            if (siz1 != siz2) {
                this.addRecord(new DiffRecord(MessageFormat.format("Size : ''size(<) {0}'' != ''size(>) {1}''", siz1, siz2)));
            }
            int i1 = 0;
            int i2 = 0;
            while (i1 < siz1 || i2 < siz2) {
                Cut cut2;
                if (i1 >= siz1) {
                    this.addRecord(new DiffRecord().setMsg1(this._cuts2.getCut(i2).toString()));
                    ++i2;
                    continue;
                }
                if (i2 >= siz2) {
                    this.addRecord(new DiffRecord().setMsg2(this._cuts1.getCut(i1).toString()));
                    ++i1;
                    continue;
                }
                Cut cut1 = this._cuts1.getCut(i1);
                int diff = cut1.compareTo(cut2 = this._cuts2.getCut(i2));
                if (diff < 0) {
                    this.addRecord(new DiffRecord().setCompare(-1).setMsg1(cut1.toString()));
                    ++i1;
                    continue;
                }
                if (diff > 0) {
                    this.addRecord(new DiffRecord().setCompare(1).setMsg1(cut2.toString()));
                    ++i2;
                    continue;
                }
                ++i1;
                ++i2;
            }
            boolean bl = this.withDiff();
            return bl;
        }
        finally {
            this.close();
        }
    }

    public static void main(String[] args) {
        block5: {
            File file1 = null;
            File file2 = null;
            if (args.length == 2) {
                try {
                    file1 = new File(args[0]);
                    file2 = new File(args[1]);
                    McsDiff diff = new McsDiff(file1, file2);
                    DestinationConsole destination = new DestinationConsole(false);
                    destination.setLayout(new DiffLayoutSimple());
                    diff.addDestination(destination);
                    if (diff.action()) {
                        System.out.println("exit 1");
                        System.exit(1);
                        break block5;
                    }
                    System.out.println("exit 0");
                    System.exit(0);
                }
                catch (IOException e) {
                    StringBuffer sb = new StringBuffer(256);
                    sb.append("Diff MCS\n");
                    sb.append("< " + file1.getPath() + "\n");
                    sb.append("> " + file2.getPath() + "\n");
                    sb.append("--------------------------------------\n\n");
                    System.err.print(sb.toString());
                    System.err.println("!!! " + e.getMessage());
                    System.exit(2);
                }
            } else {
                System.err.println("Syntax error : java -classpath ... " + McsDiff.class.getName() + " <file1> <file2>");
                System.exit(3);
            }
        }
    }
}

