/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import com.dassault.cecilia.lib.mcs.Cut;
import com.dassault.cecilia.lib.mcs.McsUser;
import com.dassault.cecilia.lib.mcs.Seq;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class McsReader {
    McsUser _user;

    public McsReader(McsUser user) {
        this._user = user;
    }

    protected void init() throws IOException {
        this._user.beginSet();
    }

    protected void defineTop(String top) {
        this._user.setTop(top);
    }

    protected void addCut(Cut cut) throws IOException {
        this._user.addCut(cut);
    }

    protected void close() throws IOException {
        this._user.endSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMcs(File input) throws IOException {
        this.init();
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(input));
            int state = 0;
            while (state < 3 && (line = ((LineNumberReader)reader).readLine()) != null) {
                line = line.trim();
                switch (state) {
                    case 0: {
                        if (!line.startsWith("products(")) break;
                        String info = line.substring(9);
                        int begin = info.indexOf(40);
                        int end = info.indexOf(41, begin + 1);
                        this.defineTop(info.substring(begin + 1, end));
                        state = 1;
                    }
                    case 1: {
                        if (!line.endsWith("=")) break;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (line.equals("end")) {
                            this.close();
                            state = 3;
                            break;
                        }
                        this.addMcs(line, ((LineNumberReader)reader).getLineNumber());
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    protected void addMcs(String buffer, int line) throws IOException {
        Cut cut = new Cut(line);
        int state = 0;
        StringBuffer tok = null;
        block8: for (int i = 0; i < buffer.length() && state < 10; ++i) {
            char car = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if (car == '{') {
                        state = 6;
                        tok = new StringBuffer(64);
                        continue block8;
                    }
                    throw new IOException("Error parsing MCS " + buffer);
                }
                case 6: {
                    if (car == '}') {
                        state = 10;
                        continue block8;
                    }
                }
                case 1: {
                    if (car == '\'' || car == '`') {
                        state = 3;
                        tok.append('\'');
                        continue block8;
                    }
                    if (Character.isLetter(car)) {
                        state = 2;
                        tok.append(car);
                        continue block8;
                    }
                    if (Character.isSpaceChar(car)) continue block8;
                    throw new IOException("Error parsing MCS " + buffer);
                }
                case 2: {
                    if (Character.isLetterOrDigit(car) || car == '_' || car == '-' || car == '.' || car == '^') {
                        tok.append(car);
                        continue block8;
                    }
                    cut.addEvt(tok.toString());
                    state = 5;
                }
                case 5: {
                    if (car == ',') {
                        state = 1;
                        tok = new StringBuffer(64);
                        continue block8;
                    }
                    if (car == '}') {
                        state = 10;
                        continue block8;
                    }
                    if (Character.isSpaceChar(car)) continue block8;
                    throw new IOException("Error parsing MCS " + buffer);
                }
                case 3: {
                    if (car == '\'') {
                        tok.append(car);
                        cut.addEvt(tok.toString());
                        state = 5;
                        continue block8;
                    }
                    tok.append(car);
                }
            }
        }
        if (state != 10) {
            throw new IOException("Error parsing MCS " + buffer);
        }
        this.addCut(cut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTxt(File input) throws IOException {
        this.init();
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(input));
            int state = 0;
            int nbrTab = 2;
            Cut cut = null;
            while (state < 4 && (line = ((LineNumberReader)reader).readLine()) != null) {
                switch (state) {
                    case 0: {
                        if (line.startsWith("Nom:")) {
                            this.defineTop(line.substring(4).trim());
                            break;
                        }
                        if (line.startsWith("Name:")) {
                            this.defineTop(line.substring(5).trim());
                            break;
                        }
                        if (!line.startsWith("COUPES MINIMALES D'ORDRE") && !line.startsWith("MINIMAL CUTS FROM ORDER")) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (!line.startsWith("Numero\t") && !line.startsWith("Num\u00e9ro\t") && !line.startsWith("Number\t")) break;
                        StringTokenizer st = new StringTokenizer(line, "\t");
                        boolean find = false;
                        nbrTab = 0;
                        while (st.hasMoreTokens() && !find) {
                            String token = st.nextToken();
                            if (token.equals("Nom")) {
                                find = true;
                            } else if (token.equals("Name")) {
                                find = true;
                            }
                            ++nbrTab;
                        }
                        if (!find) {
                            throw new IOException("Error parsing TXT [such header]\n" + line);
                        }
                        --nbrTab;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (!Character.isDigit(line.charAt(0))) break;
                        state = 3;
                    }
                    case 3: {
                        if (line.length() == 0) {
                            if (cut != null) {
                                this.addCut(cut);
                            }
                            this.close();
                            state = 4;
                            break;
                        }
                        if (Character.isDigit(line.charAt(0))) {
                            if (cut != null) {
                                this.addCut(cut);
                            }
                            cut = new Cut(((LineNumberReader)reader).getLineNumber());
                        }
                        if (cut == null) {
                            throw new IOException("Error parsing TXT [No Current Cut] " + line);
                        }
                        int begin = -1;
                        for (int i = 0; i < nbrTab; ++i) {
                            if ((begin = line.indexOf(9, begin + 1)) != -1) continue;
                            throw new IOException("Error parsing TXT " + line);
                        }
                        int end = line.indexOf(9, begin + 1);
                        if (end == -1) {
                            end = line.length();
                        }
                        cut.addEvt(line.substring(begin + 1, end));
                    }
                }
            }
            if (state == 3) {
                if (cut != null) {
                    this.addCut(cut);
                }
                this.close();
                state = 4;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void readXml(File input) throws IOException {
        this.init();
        class CutHandler
        extends SAXExtendedHandler {
            int _XMLRoot = -1;
            Cut _current = null;
            StringBuffer _bufferTop = new StringBuffer(64);
            boolean _bTree = false;

            CutHandler() {
            }

            @Override
            public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                switch (this._XMLRoot) {
                    default: {
                        if (key.equals("EXPORT")) {
                            this._XMLRoot = 1;
                            break;
                        }
                        if (key.equals("aralia-compute-result")) {
                            this._XMLRoot = 2;
                            break;
                        }
                        if (key.equals("seqgen")) {
                            this._XMLRoot = 3;
                            break;
                        }
                        if (key.equals("sequences")) {
                            this._XMLRoot = 5;
                            McsReader.this.defineTop(attrs.get("name"));
                            break;
                        }
                        throw new SAXParseException("XML document tag unknow - " + key + " != {EXPORT, aralia-compute-result, seqgen, sequences}", this.getLocator());
                    }
                    case 1: {
                        if (key.equals("CUT")) {
                            this._current = new Cut(this.getLocator().getLineNumber());
                            break;
                        }
                        if (key.equals("EVENT")) {
                            this._current.addEvt(attrs.get("NAME"));
                            break;
                        }
                        if (key.equals("TREE")) {
                            this._bTree = true;
                            break;
                        }
                        if (!key.equals("IDENTIFICATION")) break;
                        this._bufferTop.append('.');
                        this._bufferTop.append(attrs.get("NAME"));
                        if (!this._bTree) break;
                        if (this._bufferTop.length() > 0) {
                            this._bufferTop.setCharAt(0, '\'');
                            this._bufferTop.append('\'');
                        } else {
                            this._bufferTop.append("MCSReaderRoot");
                        }
                        McsReader.this.defineTop(this._bufferTop.toString());
                        this._bTree = false;
                        break;
                    }
                    case 2: {
                        if (key.equals("products") || key.equals("sum-of-products")) {
                            McsReader.this.defineTop(attrs.get("variable"));
                            break;
                        }
                        if (key.equals("product")) {
                            this._current = new Cut(this.getLocator().getLineNumber());
                            break;
                        }
                        if (!key.equals("variable")) break;
                        this._current.addEvt(attrs.get("name"));
                        break;
                    }
                    case 3: {
                        if (key.equals("target")) {
                            McsReader.this.defineTop(attrs.get("name") + "." + attrs.get("value"));
                            break;
                        }
                        if (key.equals("param")) {
                            if (!attrs.get("name").equals("resultset")) break;
                            if (attrs.get("value").equals("minseqs")) {
                                this._XMLRoot = 4;
                                break;
                            }
                            if (attrs.get("value").equals("mincuts")) break;
                            throw new SAXParseException("XML 'seqgen' must be with minimal result (minseqs or mincuts)", this.getLocator());
                        }
                        if (key.equals("seq")) {
                            this._current = new Cut(this.getLocator().getLineNumber());
                            break;
                        }
                        if (!key.equals("tr")) break;
                        this._current.addEvt(attrs.get("evt"));
                        break;
                    }
                    case 4: {
                        if (key.equals("seq")) {
                            this._current = new Seq(this.getLocator().getLineNumber());
                            break;
                        }
                        if (!key.equals("tr")) break;
                        this._current.addEvt(attrs.get("evt"));
                        break;
                    }
                    case 5: {
                        if (key.equals("sequence")) {
                            this._current = new Seq(this.getLocator().getLineNumber());
                            break;
                        }
                        if (!key.equals("transition")) break;
                        this._current.addEvt(attrs.get("event"));
                    }
                }
            }

            @Override
            public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
                try {
                    switch (this._XMLRoot) {
                        case 1: {
                            if (key.equals("CUT")) {
                                McsReader.this.addCut(this._current);
                                break;
                            }
                            if (!key.equals("TREE")) break;
                            this._bTree = false;
                            break;
                        }
                        case 2: {
                            if (!key.equals("product")) break;
                            McsReader.this.addCut(this._current);
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (!key.equals("seq")) break;
                            McsReader.this.addCut(this._current);
                            break;
                        }
                        case 5: {
                            if (!key.equals("sequence")) break;
                            McsReader.this.addCut(this._current);
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new SAXParseException("IOException during use MCSData", this.getLocator(), ioe);
                }
                return false;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                try {
                    URL url;
                    if (systemId.startsWith("file:") && !new File((url = new URL(systemId)).getFile()).exists()) {
                        return new InputSource(new StringReader("<?xml version='1.0' encoding='ISO-8859-1'?>\n"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.resolveEntity(publicId, systemId);
            }
        }
        CutHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new CutHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            if (handler != null && (loc = handler.getLocator()) != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString());
        }
    }

    public void readDag(File input) throws IOException {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXfta(File input) throws IOException {
        this.init();
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(input));
            this.defineTop("r");
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                line = line.trim();
                Cut cut = new Cut(((LineNumberReader)reader).getLineNumber());
                StringTokenizer strTok = new StringTokenizer(line, "\t");
                while (strTok.hasMoreTokens()) {
                    cut.addEvt(strTok.nextToken());
                }
                this.addCut(cut);
            }
            this.close();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findExtention(File input) throws IOException {
        String result = "???";
        String path = input.getAbsolutePath();
        int pos = path.lastIndexOf(46);
        if (pos != -1) {
            result = path.substring(pos + 1);
        }
        try (BufferedReader read = new BufferedReader(new FileReader(input));){
            String line = read.readLine();
            while (line != null) {
                if (line.startsWith("<?xml")) {
                    result = "xml";
                } else if (line.startsWith("products(")) {
                    result = "mcs";
                } else {
                    String trim = line.trim();
                    if (trim.length() == 0 || trim.startsWith("//") || trim.startsWith("/*") && trim.endsWith("*/")) {
                        line = read.readLine();
                        continue;
                    }
                }
                break;
            }
        }
        return result;
    }

    public void readXxx(File input, String dext) throws IOException {
        String ext = dext;
        if (ext == null || ext.length() == 0) {
            ext = this.findExtention(input);
        }
        if (ext.equalsIgnoreCase("xml")) {
            this.readXml(input);
        } else if (ext.equalsIgnoreCase("txt")) {
            this.readTxt(input);
        } else if (ext.equalsIgnoreCase("mcs")) {
            this.readMcs(input);
        } else if (ext.equalsIgnoreCase("xfta")) {
            this.readXfta(input);
        } else if (ext.equalsIgnoreCase("seq")) {
            this.readMcs(input);
        } else if (ext.equalsIgnoreCase("dag")) {
            this.readDag(input);
        } else {
            throw new IOException("Format Unknow : " + input.getPath());
        }
    }
}

