/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class McsToCVS {
    File _input;
    PrintWriter _outputWriter;
    char _sepToken;
    private static String SYNTAX = "Syntax : java -classpath ... " + McsToCVS.class.getName() + " \n   [--input <input>]    \n   [-i <input>]         // input file\n   [--output <output>]  \n   [-o <output>]        // output file\n   [--separator <sep>]  // only one character\nIf input ou output not define, launch a system FileChooser.";

    public McsToCVS(File input, Writer outWriter, char sep) {
        this._input = input;
        this._outputWriter = new PrintWriter(outWriter);
        this._sepToken = sep;
    }

    public void action() throws IOException {
        class CutHandler
        extends SAXExtendedHandler {
            StringBuilder _line = new StringBuilder(128);

            CutHandler() {
            }

            @Override
            public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                if (key.equals("CUT")) {
                    String prb;
                    if (this._line.length() > 0) {
                        this._line.delete(0, this._line.length() - 1);
                    }
                    if ((prb = attrs.get("PROBABILITY")) != null) {
                        this._line.append(prb);
                    }
                } else if (key.equals("EVENT")) {
                    this._line.append(McsToCVS.this._sepToken);
                    this._line.append(attrs.get("NAME"));
                    this._line.append(McsToCVS.this._sepToken);
                    String prb = attrs.get("PROBABILITY");
                    if (prb != null) {
                        this._line.append(prb);
                    }
                }
            }

            @Override
            public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
                if (key.equals("CUT")) {
                    McsToCVS.this._outputWriter.print(this._line.toString());
                    McsToCVS.this._outputWriter.println();
                }
                return false;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                try {
                    URL url;
                    if (systemId.startsWith("file:") && !new File((url = new URL(systemId)).getFile()).exists()) {
                        return new InputSource(new StringReader("<?xml version='1.0' encoding='ISO-8859-1'?>\n"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.resolveEntity(publicId, systemId);
            }
        }
        CutHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new CutHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(this._input, (DefaultHandler)handler);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            if (handler != null && (loc = handler.getLocator()) != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]\n");
            }
            sb.append(e.getMessage());
            throw new IOException(sb.toString());
        }
    }

    public static void main(String[] args) {
        Writer writer = null;
        File input = null;
        char sep = '\t';
        Object errorMsg = null;
        if (errorMsg == null) {
            for (int idx = 0; idx < args.length && errorMsg == null; ++idx) {
                if (args[idx].equals("--input") || args[idx].equals("-i")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--input'";
                        continue;
                    }
                    input = new File(args[idx]);
                    continue;
                }
                if (args[idx].equals("--output") || args[idx].equals("-o")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--output'";
                        continue;
                    }
                    try {
                        writer = new FileWriter(args[idx]);
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                    continue;
                }
                if (args[idx].equals("--separator")) {
                    if (++idx == args.length) {
                        errorMsg = "Number argument of '--separator'";
                        continue;
                    }
                    String sepStr = args[idx];
                    if (sepStr.isEmpty() || sepStr.length() > 1) {
                        errorMsg = "'separator' format (must be only one character)";
                        continue;
                    }
                    sep = sepStr.charAt(0);
                    continue;
                }
                if (args[idx].equals("--help")) {
                    System.out.println(SYNTAX);
                    System.exit(0);
                    continue;
                }
                errorMsg = "Unkown argument: " + args[idx];
            }
        }
        if (errorMsg == null) {
            JFileChooser dlg = null;
            if (input == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                }
                if (dlg.showOpenDialog(null) == 1) {
                    errorMsg = "Cancel input";
                } else {
                    input = dlg.getSelectedFile();
                }
            }
            if (errorMsg == null && input == null) {
                errorMsg = "No input";
            }
            if (writer == null) {
                if (dlg == null) {
                    dlg = new JFileChooser();
                    dlg.setCurrentDirectory(new File("."));
                }
                if (dlg.showSaveDialog(null) == 1) {
                    errorMsg = "Cancel output";
                } else if (dlg.getSelectedFile() == null) {
                    errorMsg = "No select output";
                } else {
                    try {
                        writer = new FileWriter(dlg.getSelectedFile());
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        errorMsg = "Output exception";
                    }
                }
            }
            if (errorMsg == null && writer == null) {
                errorMsg = "No output";
            }
        }
        if (errorMsg == null) {
            try {
                McsToCVS conv = new McsToCVS(input, writer, sep);
                conv.action();
                writer.close();
                System.exit(0);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else {
            System.err.println((String)errorMsg);
            System.err.println();
            System.err.println(SYNTAX);
            System.exit(3);
        }
    }
}

