/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.mcs.McsToAralia;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class MCS2Aralia
extends Unit {
    UtilFileSrc _src = new UtilFileSrc();
    UtilFileDst _dst = new UtilFileDst();
    String _separator = ".";
    String _size = "100";

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setText(String value) {
        this._src.setText(value);
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
        this._dst.setProcess(process);
    }

    public void endValid() {
        this._src.endValid();
        this._dst.endValid();
    }

    public void setSeparator(String value) {
        this._separator = value;
    }

    public char getSeparator() {
        String value = this.expanse(this._separator);
        if (value.length() != 1) {
            throw new BanProcessException("Attribute 'separator' must be only one char : [" + value + "]");
        }
        return value.charAt(0);
    }

    public void setSize(String value) {
        this._size = value;
    }

    protected int getSize() {
        String value = this.expanse(this._size);
        int result = this.castInt(value, "size");
        if (result <= 0) {
            throw new BanProcessException("Attribute 'size' must be a positive integer");
        }
        return result;
    }

    @Override
    public void execute() {
        File src = this._src.getSrcFile();
        File dst = this._dst.getDstFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(dst);
            McsToAralia conv = new McsToAralia(src, writer, this.getSize(), this.getSeparator());
            conv.action();
        }
        catch (IOException e) {
            throw new BanProcessException("mcs2aralia - IOException", e);
        }
        try {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            this.log("IOException during close writer : " + e.getMessage(), 1);
        }
    }
}

