/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.ban.aralia;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mcs.ban.aralia.AraliaCompute;
import com.dassault.cecilia.lib.mcs.ban.aralia.ItemCompute;
import com.dassault.cecilia.lib.mcs.ban.aralia.TypePropagate;
import com.dassault.cecilia.lib.mcs.ban.aralia.TypeTimes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ItemPr
extends ItemCompute {
    String _from = From.BDD.name();
    TypeTimes _times;
    TypePropagate _propagate;

    public void setFrom(String value) {
        this._from = value;
    }

    protected boolean fromBDD() {
        String from = this.expanse(this._from);
        From result = null;
        try {
            result = From.valueOf(from);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            throw new BanProcessException("Attribute 'from' not include possibles values : " + From.values());
        }
        return result == From.BDD;
    }

    public TypeTimes createTimes() {
        if (this._times != null) {
            throw new BanProcessException("Only one child element 'times'");
        }
        this._times = new TypeTimes();
        return this._times;
    }

    public TypePropagate createPropagate() {
        if (this._propagate != null) {
            throw new BanProcessException("Only one child element 'propagate'");
        }
        this._propagate = new TypePropagate();
        return this._propagate;
    }

    @Override
    protected void writeScript(BufferedWriter writer, AraliaCompute compute, File dst) throws IOException {
        Map<String, String> opts = this.getOptions();
        boolean leaves = false;
        String opt = opts.get("leaves");
        if (opt != null) {
            leaves = this.castBool(opt, null);
        }
        boolean root = true;
        String opt2 = opts.get("root");
        if (opt2 != null) {
            root = this.castBool(opt2, null);
        }
        if (this._propagate != null) {
            this._propagate.writeOptions(writer);
        }
        writer.write("compute ");
        if (this.fromBDD()) {
            writer.write("Pr from Good-BDD ");
        } else {
            writer.write("PP from Good-ZBDD ");
        }
        if (root) {
            writer.write(compute.getRoot());
        }
        if (leaves && root) {
            writer.write(",");
        }
        if (leaves) {
            writer.write("leaves(");
            writer.write(compute.getRoot());
            writer.write(")");
        }
        writer.write(" ");
        if (this._times != null) {
            writer.write(this._times.toAraliaString());
        } else {
            writer.write("at ");
            writer.write(Double.toString(compute.getTime()));
        }
        writer.write(" ");
        if (this._propagate != null) {
            writer.write(this._propagate.appendCommand());
        }
        writer.write(" >> \"");
        writer.write(dst.getAbsolutePath());
        writer.write("\" ;");
        writer.newLine();
    }

    static enum From {
        BDD,
        MCS;

    }
}

