/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.ban.ceciliabdd;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mcs.ban.ceciliabdd.BDDCompute;
import com.dassault.cecilia.lib.mcs.ban.ceciliabdd.ItemCompute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ItemMCS
extends ItemCompute {
    String _algo = Algo.ZQC.name();
    String _truncated;

    public void setAlgo(String value) {
        this._algo = value;
    }

    protected Algo getAlgo() {
        String algo = this.expanse(this._algo);
        Algo result = null;
        try {
            result = Algo.valueOf(algo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result == null) {
            throw new BanProcessException("Attribute 'algo' not include possibles values : " + Algo.values());
        }
        return result;
    }

    public void setTruncated(String value) {
        this._truncated = value;
    }

    protected int getTruncated() {
        int result = 0;
        if (this._truncated != null && (result = this.castInt(this.expanse(this._truncated), "truncated")) < 0) {
            throw new BanProcessException("Attribut 'truncated' must be integer greater than 0");
        }
        return result;
    }

    protected void writeMCSScript(BufferedWriter writer, BDDCompute compute) throws IOException {
        Algo algo = this.getAlgo();
        int trunc = this.getTruncated();
        Map<String, String> opts = this.getOptions();
        if (algo == Algo.pBDD) {
            String pBDDName;
            boolean back = true;
            String optBack = opts.get("compute-back");
            if (optBack != null) {
                back = this.castBool(optBack, null);
            }
            String string = pBDDName = back ? " Pseudo-BDD " : " Good-BDD ";
            if (trunc == 0) {
                throw new BanProcessException("Attribut 'truncated' must be declared if 'algo' is p-BDD");
            }
            writer.write("compute PBDD truncated ");
            writer.write(Integer.toString(trunc));
            writer.write(" to");
            writer.write(pBDDName);
            writer.write(compute.getRoot());
            writer.write(" ;");
            writer.newLine();
            writer.write("compute ZQC from");
            writer.write(pBDDName);
            writer.write("to Good-ZBDD ");
            writer.write(compute.getRoot());
            writer.write(" ;");
            writer.newLine();
            if (back) {
                writer.write("compute SOP from Good-ZBDD to Good-BDD ");
                writer.write(compute.getRoot());
                writer.write(" ;");
                writer.newLine();
            }
        } else {
            writer.write("compute BDD to Good-BDD ");
            writer.write(compute.getRoot());
            writer.write(" ;");
            writer.newLine();
            writer.write("compute ");
            if (algo == Algo.ZPI) {
                writer.write("ZPI ");
            } else {
                writer.write("ZQC ");
            }
            if (trunc > 0) {
                writer.write("truncated " + trunc);
            }
            writer.write("from Good-BDD to Good-ZBDD ");
            writer.write(compute.getRoot());
            writer.write(" ;");
            writer.newLine();
        }
    }

    @Override
    protected void writeScript(BufferedWriter writer, BDDCompute compute, File dst) throws IOException {
        Map<String, String> opts = this.getOptions();
        boolean products = true;
        String optProducts = opts.get("products");
        if (optProducts != null) {
            products = this.castBool(optProducts, null);
        }
        boolean orders = false;
        String optOrders = opts.get("orders");
        if (optOrders != null) {
            orders = this.castBool(optOrders, null);
        }
        if (!products && !orders && compute._computeList.size() < 1) {
            this.log("No output result generate", 1);
        }
        if (orders) {
            writer.write("display orders Good-ZBDD ");
            writer.write(compute.getRoot());
            writer.write(" >> \"");
            writer.write(dst.getAbsolutePath());
            writer.write("\" ;");
            writer.newLine();
        }
        if (products) {
            writer.write("display products Good-ZBDD ");
            writer.write(compute.getRoot());
            writer.write(" >> \"");
            writer.write(dst.getAbsolutePath());
            writer.write("\" ;");
            writer.newLine();
        }
    }

    static enum Algo {
        ZQC,
        pBDD,
        ZPI;

    }
}

