/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.bdd;

import com.dassault.cecilia.lib.mcs.bdd.BDDIte;

public class BDDHashOp {
    BDDRecordOp[] _table;
    int _curSize;
    int _minSize;
    int _maxSize;
    float _ratioEnlarg;
    float _ratioReduce;
    int _nbrRecord;
    int _nbrRecordEnlarg;

    public BDDHashOp(int min, int cur, int max) {
        assert (min > 0 && min <= cur && cur <= max);
        this._minSize = min;
        this._curSize = cur;
        this._maxSize = max;
        this._ratioEnlarg = 0.5f;
        this._ratioReduce = 0.1f;
        this._nbrRecord = 0;
        this._nbrRecordEnlarg = this._curSize >= this._maxSize ? Integer.MAX_VALUE : (int)((float)this._curSize * this._ratioEnlarg);
        this._table = new BDDRecordOp[this._curSize];
    }

    protected int computeHashCode(Object key1, Object key2, Object key3) {
        int result = 0;
        if (key1 != null) {
            result += 7 * key1.hashCode();
        }
        if (key2 != null) {
            result += 13 * key2.hashCode();
        }
        if (key3 != null) {
            result += 17 * key3.hashCode();
        }
        if (result < 0) {
            result *= -1;
        }
        return result % this._curSize;
    }

    protected void resize(int newSize) {
        BDDRecordOp[] table = this._table;
        int oldSize = this._curSize;
        this._table = new BDDRecordOp[newSize];
        this._curSize = newSize;
        this._nbrRecord = 0;
        for (int i = 0; i < oldSize; ++i) {
            BDDRecordOp record = table[i];
            if (record == null) continue;
            int idx = this.computeHashCode(record._key1, record._key2, record._key3);
            if (this._table[idx] == null) {
                ++this._nbrRecord;
            }
            this._table[idx] = record;
            table[i] = null;
        }
        this._nbrRecordEnlarg = this._curSize >= this._maxSize ? Integer.MAX_VALUE : (int)((float)this._curSize * this._ratioEnlarg);
    }

    public void put(Object key1, Object key2, Object key3, Object result) {
        int idx = this.computeHashCode(key1, key2, key3);
        if (this._table[idx] == null) {
            ++this._nbrRecord;
            this._table[idx] = new BDDRecordOp(key1, key2, key3, result);
        } else {
            BDDRecordOp record = this._table[idx];
            record._key1 = key1;
            record._key2 = key2;
            record._key3 = key3;
            record._result = result;
        }
        if (this._nbrRecord >= this._nbrRecordEnlarg) {
            this.resize(this._curSize * 2);
        }
    }

    public Object get(Object key1, Object key2, Object key3) {
        int idx = this.computeHashCode(key1, key2, key3);
        if (this._table[idx] == null) {
            return null;
        }
        return this._table[idx]._result;
    }

    public String displayStatistics(String header) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("/*Hash Operation Parameters*/\n");
        sb.append(header).append("size.min = ").append(this._minSize).append("\n");
        sb.append(header).append("size.max = ").append(this._maxSize).append("\n");
        sb.append(header).append("size.cur = ").append(this._curSize).append("\n");
        sb.append(header).append("ratio.enlarg = ").append(this._ratioEnlarg).append("\n");
        sb.append(header).append("ratio.reduce = ").append(this._ratioReduce).append("\n");
        sb.append("/*Hash Operation Statistics\n");
        sb.append(header).append("record.nbr = ").append(this._nbrRecord).append("\n");
        sb.append(" */\n");
        return sb.toString();
    }

    public void defineSize(int min, int cur, int max) {
        assert (min > 0 && min <= cur && cur <= max);
        this._minSize = min;
        this._maxSize = max;
        this.resize(cur);
    }

    public void defineRatio(float enlarg, float reduce) {
        this._ratioEnlarg = enlarg;
        this._ratioReduce = reduce;
        int n = this._nbrRecordEnlarg = this._curSize >= this._maxSize ? Integer.MAX_VALUE : (int)((float)this._curSize * this._ratioEnlarg);
        if (this._nbrRecord >= this._nbrRecordEnlarg) {
            this.resize(this._curSize * 2);
        } else if (this._curSize >= this._minSize && (float)this._nbrRecord < (float)this._curSize * this._ratioReduce) {
            this.resize(this._curSize / 2);
        }
    }

    public void gc() {
        for (int i = 0; i < this._curSize; ++i) {
            BDDRecordOp record = this._table[i];
            if (record == null || !record.isDisconnect()) continue;
            record._key1 = null;
            record._key2 = null;
            record._key3 = null;
            record._result = null;
            this._table[i] = null;
            --this._nbrRecord;
        }
        if (this._curSize >= this._minSize && (float)this._nbrRecord < (float)this._curSize * this._ratioReduce) {
            this.resize(this._curSize / 2);
        }
    }

    class BDDRecordOp {
        Object _key1;
        Object _key2;
        Object _key3;
        Object _result;

        BDDRecordOp(Object key1, Object key2, Object key3, Object result) {
            this._key1 = key1;
            this._key2 = key2;
            this._key3 = key3;
            this._result = result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(128);
            sb.append("fct(");
            if (this._key1 != null) {
                sb.append(this._key1).append(";");
            }
            if (this._key2 != null) {
                sb.append(this._key2).append(";");
            }
            if (this._key2 != null) {
                sb.append(this._key3).append(";");
            }
            sb.append(")=").append(this._result);
            return sb.toString();
        }

        public boolean isDisconnect() {
            if (this._key1 instanceof BDDIte && ((BDDIte)this._key1)._count == '\u0000') {
                return true;
            }
            if (this._key2 instanceof BDDIte && ((BDDIte)this._key2)._count == '\u0000') {
                return true;
            }
            if (this._key3 instanceof BDDIte && ((BDDIte)this._key3)._count == '\u0000') {
                return true;
            }
            return this._result instanceof BDDIte && ((BDDIte)this._result)._count == '\u0000';
        }
    }
}

