/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class AlphaNumComparator
implements Comparator<String> {
    private static final AlphaNumComparator CASE_SENSITIVE_COMPARATOR = new AlphaNumComparator(false);
    private static final AlphaNumComparator IGNORING_CASE_COMPARATOR = new AlphaNumComparator(true);
    private boolean _ignoringCase;
    private static final String DIGITS = "(\\p{Digit}+)";
    private static final String EXP = "[eE][+-]?(\\p{Digit}+)";
    private static final String FP_REGEXPR = "[+-]?(((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?))";
    private static final Pattern PATTERN_NUMBER = Pattern.compile("[+-]?(((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?))");

    public static Comparator<String> getInstance(boolean ignoringCase) {
        if (ignoringCase) {
            return IGNORING_CASE_COMPARATOR;
        }
        return CASE_SENSITIVE_COMPARATOR;
    }

    public AlphaNumComparator(boolean ignoringCase) {
        this._ignoringCase = ignoringCase;
    }

    public AlphaNumComparator() {
        this(false);
    }

    private boolean isNum(String val) {
        return PATTERN_NUMBER.matcher(val).matches();
    }

    @Override
    public int compare(String s1, String s2) {
        if (this.isNum(s1) && this.isNum(s2)) {
            return Double.compare(Double.parseDouble(s1), Double.parseDouble(s2));
        }
        if (this._ignoringCase) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
        }
        int s1Idx = 0;
        int s2Idx = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        String s1Chunk = null;
        String s2Chunk = null;
        while (s1Idx < s1Length && s2Idx < s2Length) {
            boolean s1chunkIsDigit = Character.isDigit(s1.charAt(s1Idx));
            s1Chunk = s1chunkIsDigit ? this.getDigitChunk(s1, s1Length, s1Idx, false) : this.getStringChunk(s1, s1Length, s1Idx);
            s1Idx += s1Chunk.length();
            boolean s2chunkIsDigit = Character.isDigit(s2.charAt(s2Idx));
            s2Chunk = s2chunkIsDigit ? this.getDigitChunk(s2, s2Length, s2Idx, false) : this.getStringChunk(s2, s2Length, s2Idx);
            s2Idx += s2Chunk.length();
            int result = 0;
            if (s1chunkIsDigit && s2chunkIsDigit) {
                result = Double.compare(Double.parseDouble(s1Chunk), Double.parseDouble(s2Chunk));
                if (result == 0) {
                    result = s1Chunk.compareTo(s2Chunk);
                }
            } else {
                result = s1Chunk.compareTo(s2Chunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    private final String getStringChunk(String s, int slength, int idx) {
        char c;
        StringBuilder chunk = new StringBuilder();
        assert (!Character.isDigit(s.charAt(idx)));
        while (idx < slength && !Character.isDigit(c = s.charAt(idx))) {
            chunk.append(c);
            ++idx;
        }
        return chunk.toString();
    }

    private final String getDigitChunk(String s, int slength, int idx, boolean prefixMinus) {
        char c;
        StringBuilder chunk = new StringBuilder();
        if (prefixMinus) {
            chunk.append("-");
        }
        assert (Character.isDigit(s.charAt(idx)));
        while (idx < slength && Character.isDigit(c = s.charAt(idx))) {
            chunk.append(c);
            ++idx;
        }
        return chunk.toString();
    }

    public static void main(String[] args) {
        TreeSet<String> tests = new TreeSet<String>(new AlphaNumComparator(true));
        tests.add("10");
        tests.add("10.8");
        tests.add("10.70");
        tests.add("1");
        tests.add("1.9");
        tests.add("3.");
        tests.add("12");
        tests.add("100");
        tests.add("toto1");
        tests.add("titi10");
        tests.add("toto2");
        tests.add("toto10");
        tests.add("toto11A10");
        tests.add("toto11A2");
        tests.add("toto11A20");
        tests.add("Toto");
        tests.add("tiTi10");
        tests.add("TOTO2");
        tests.add("TOTO3");
        tests.add("BABAR");
        tests.add("bebe");
        tests.add("arbre");
        tests.add("Bonjour");
        tests.add("bonjour");
        tests.add("toto10");
        tests.add("-10");
        tests.add("-100");
        tests.add("0");
        tests.add("-1");
        tests.add("toti");
        tests.add("tutu");
        tests.add("toto255");
        tests.add("tot1");
        tests.add("toto");
        tests.add("toto");
        tests.add("'SIF003A1'");
        tests.add("'SIF3A001'");
        Iterator<String> it = tests.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

