/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class ImageUtility {
    private static Logger _LOG = Logger.getLogger(ImageUtility.class.getPackage().getName());
    private static File __fileCSSforSVG = null;
    private static boolean __fileCSSforSVGCreate = false;
    private static Object __fileCSSforSVGLocker = new Object();
    static SAXSVGDocumentFactory _SVGFactory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());

    public static Image getImageFromSVG(URL url, int width, int height) {
        DefaultTranscoder transcoder = new DefaultTranscoder();
        TranscodingHints hints = transcoder.getTranscodingHints();
        hints.put((Object)SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        hints.put((Object)SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        transcoder.setTranscodingHints(hints);
        try {
            TranscoderInput input = new TranscoderInput(url.openStream());
            input.setURI(url.toURI().toString());
            transcoder.transcode(input, null);
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Transcodage SVG KO", e);
            return null;
        }
        return transcoder.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileCSSForSVG() {
        if (__fileCSSforSVG == null) {
            Object object = __fileCSSforSVGLocker;
            synchronized (object) {
                if (!__fileCSSforSVGCreate) {
                    __fileCSSforSVGCreate = true;
                    try {
                        __fileCSSforSVG = File.createTempFile("batik-default-override-", ".css");
                        __fileCSSforSVG.deleteOnExit();
                        String css = "svg {shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;}";
                        FileWriter writer = new FileWriter(__fileCSSforSVG);
                        writer.write(css);
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    }
                    catch (IOException e) {
                        __fileCSSforSVG = null;
                        _LOG.log(Level.SEVERE, "Impossible de creer le fichier CSS", e);
                    }
                }
            }
        }
        return __fileCSSforSVG;
    }

    public static SVGDocument createSVGDocument(InputStream is) throws IOException {
        return (SVGDocument)_SVGFactory.createDocument("bytes:cecilia:svg", is);
    }

    public static GraphicsNode buildSVGGraphicsNode(SVGDocument document) {
        UserAgentAdapter agent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)agent);
        BridgeContext context = new BridgeContext((UserAgent)agent, loader);
        context.setDynamicState(2);
        return new GVTBuilder().build(context, (Document)document);
    }

    public static GraphicsNode buildSVGGraphicsNode(InputStream is) throws IOException {
        SVGDocument document = ImageUtility.createSVGDocument(is);
        return ImageUtility.buildSVGGraphicsNode(document);
    }

    public static Dimension readDimensionSVG(InputStream is) {
        try {
            SVGDocument document = ImageUtility.createSVGDocument(is);
            GraphicsNode node = ImageUtility.buildSVGGraphicsNode(document);
            return ImageUtility.readDimensionSVG(document, node);
        }
        catch (Exception error) {
            _LOG.log(Level.SEVERE, "Exception during readDimension", error);
            return null;
        }
    }

    public static Dimension readDimensionSVG(SVGDocument document, GraphicsNode node) {
        SVGSVGElement elem = document.getRootElement();
        String width = elem.getAttribute("width");
        String height = elem.getAttribute("height");
        if (!width.isEmpty() && !height.isEmpty()) {
            return new Dimension((int)node.getSensitiveBounds().getWidth(), (int)node.getSensitiveBounds().getHeight());
        }
        String viewBox = elem.getAttribute("viewBox");
        if (!viewBox.isEmpty()) {
            String[] fieldViewBox = viewBox.split(" ");
            width = fieldViewBox[2];
            height = fieldViewBox[3];
            return new Dimension((int)Double.parseDouble(width), (int)Double.parseDouble(height));
        }
        return null;
    }

    public static BufferedImage svgBytesToBufferedImage(byte[] bytes) throws IOException {
        Dimension size = ImageUtility.readDimensionSVG(new ByteArrayInputStream(bytes));
        return ImageUtility.svgBytesToBufferedImage(new ByteArrayInputStream(bytes), size);
    }

    public static BufferedImage svgBytesToBufferedImage(InputStream inputStream, Dimension size) throws IOException {
        File cssFile = ImageUtility.getFileCSSForSVG();
        TranscodingHints transcoderHints = new TranscodingHints();
        transcoderHints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        if (cssFile != null) {
            transcoderHints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)cssFile.toURI().toString());
        }
        if (size != null) {
            transcoderHints.put((Object)SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(size.width));
            transcoderHints.put((Object)SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(size.height));
        }
        try {
            TranscoderInput input = new TranscoderInput(inputStream);
            DefaultTranscoder t = new DefaultTranscoder();
            t.setTranscodingHints(transcoderHints);
            t.transcode(input, null);
            BufferedImage result = t.getImage();
            _LOG.finest("W:" + result.getWidth() + " H:" + result.getHeight());
            return result;
        }
        catch (TranscoderException ex) {
            throw new IOException("Couldn't transcode SVG", ex);
        }
    }

    public static BufferedImage toBufferedImage(Image img, Dimension size) {
        BufferedImage bimg;
        if (img instanceof BufferedImage && (double)(bimg = (BufferedImage)img).getWidth() == size.getWidth() && (double)bimg.getHeight() == size.getHeight()) {
            return bimg;
        }
        BufferedImage bimage = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 2);
        Graphics2D bGr = bimage.createGraphics();
        new ImageIcon(img.getScaledInstance((int)size.getWidth(), (int)size.getHeight(), 4)).paintIcon(null, bGr, 0, 0);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image img, int size) {
        if (img instanceof BufferedImage && ((BufferedImage)img).getWidth() == size) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(size, size, 2);
        Graphics2D bGr = bimage.createGraphics();
        new ImageIcon(img.getScaledInstance(size, size, 4)).paintIcon(null, bGr, 0, 0);
        bGr.dispose();
        return bimage;
    }

    public static double getImageSVGRatio(URL url) throws IOException {
        return ImageUtility.doGetImageSVGRatio(url);
    }

    private static double doGetImageSVGRatioAlternative(URL url) throws IOException {
        InputStream is = url.openStream();
        Document document = _SVGFactory.createDocument(url.toString(), is);
        UserAgentAdapter agent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)agent);
        BridgeContext context = new BridgeContext((UserAgent)agent, loader);
        context.setDynamic(true);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode root = builder.build(context, document);
        return root.getPrimitiveBounds().getWidth() / root.getPrimitiveBounds().getHeight();
    }

    private static double doGetImageSVGRatio(URL url) throws IOException {
        InputStream is = url.openStream();
        SVGDocument doc = (SVGDocument)_SVGFactory.createDocument(null, is);
        if (doc != null) {
            SVGSVGElement el = doc.getRootElement();
            String viewBoxStr = el.getAttributeNS(null, "viewBox");
            float[] rect = ViewBox.parseViewBoxAttribute((Element)el, (String)viewBoxStr, null);
            return rect[2] / rect[3];
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageDimension(URL url) throws IOException {
        InputStream stream = url.openStream();
        ImageInputStream in = ImageIO.createImageInputStream(stream);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
            finally {
                reader.dispose();
            }
        }
        throw new IOException("Fail to get image dimension " + url.toString());
    }

    static class DefaultTranscoder
    extends ImageTranscoder {
        private BufferedImage image = null;

        DefaultTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput out) {
            this.image = img;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

