/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import com.dassault.cecilia.core.ConfigProperty;
import com.dassault.cecilia.lib.util.ImageUtility;
import com.dassault.cecilia.lib.util.ResMsgAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public abstract class ResIcoAbstract
extends ResMsgAbstract {
    private static Logger _LOG = Logger.getLogger(ResIcoAbstract.class.getPackage().getName());
    private Map<String, ImageIcon> _map = new HashMap<String, ImageIcon>();

    @Override
    public String getResourceName() {
        return this.getClass().getPackage().getName() + ".Icons";
    }

    @Override
    public final String getPrivateString(String key) {
        return super.getPrivateString(key);
    }

    public URL getResource(String key) {
        String path = this.getPrivateString(key);
        if (path != null) {
            return this.getClass().getClassLoader().getResource(path);
        }
        return null;
    }

    public Image getImage(String key, int widthIfSVG, int heightIfSVG) {
        URL url = this.getResource(key);
        if (url == null) {
            Logger.getLogger(this.getClass().getPackage().getName()).severe("URL not found " + this.getIDKey() + "#" + key);
            return null;
        }
        Image img = ResIcoAbstract.getImage(url, widthIfSVG, heightIfSVG);
        if (img == null) {
            Logger.getLogger(this.getClass().getPackage().getName()).severe("Image not load " + this.getIDKey() + "#" + key);
        }
        return img;
    }

    public ImageIcon getIcon(String key, int size) {
        ImageIcon icon = this._map.get(key + "#" + size);
        if (icon != null) {
            return icon;
        }
        URL url = this.getResource(key);
        if (url == null) {
            Logger.getLogger(this.getClass().getPackage().getName()).severe("Image not found " + this.getIDKey() + "#" + key);
        } else {
            Image img = ResIcoAbstract.getImageRes(url, size);
            if (img != null) {
                icon = new ImageIcon(img);
            }
        }
        if (icon != null) {
            this._map.put(key + "#" + size, icon);
        }
        return icon;
    }

    public static int getIconSize() {
        return ResIcoAbstract.getDpiScaledValue(20);
    }

    public static double getRealDpiScaledRatio() {
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        return (double)dpi / 96.0;
    }

    public static double getDpiScaledRatio() {
        if (ConfigProperty.getJVMVersion() > 9) {
            return 1.0;
        }
        return ResIcoAbstract.getRealDpiScaledRatio();
    }

    public static double getDpiScaledValue(double size) {
        return size * ResIcoAbstract.getDpiScaledRatio();
    }

    public static int getDpiScaledValue(int size) {
        return (int)ResIcoAbstract.getDpiScaledValue((double)size);
    }

    public static ImageIcon getIconRes(URL url) {
        Image img = ResIcoAbstract.getImageRes(url, ResIcoAbstract.getIconSize());
        if (img != null) {
            return new ImageIcon(img);
        }
        return null;
    }

    public static Image getImageRes(URL url, int size) {
        if (size != -1) {
            if (ConfigProperty.getJVMVersion() > 8) {
                double dpi = ResIcoAbstract.getRealDpiScaledRatio();
                double[] coefs = Double.compare(1.0, dpi) == 0 ? new double[]{1.0} : new double[]{1.0, ResIcoAbstract.getRealDpiScaledRatio()};
                int[] sizes = new int[coefs.length];
                for (int i = 0; i < coefs.length; ++i) {
                    sizes[i] = (int)((double)size * coefs[i]);
                }
                Image[] images = new Image[sizes.length];
                String lowerurl = url.toString().toLowerCase();
                if (lowerurl.endsWith(".svg")) {
                    for (int i = 0; i < sizes.length; ++i) {
                        images[i] = ResIcoAbstract.getImage(url, -1, sizes[i]);
                    }
                } else {
                    Image img = ResIcoAbstract.getImage(url);
                    for (int i = 0; i < sizes.length; ++i) {
                        images[i] = ImageUtility.toBufferedImage(img, sizes[i]);
                    }
                }
                try {
                    Class<?> baseMultiResolutionImageClass = Class.forName("java.awt.image.BaseMultiResolutionImage");
                    Constructor<?> constructorIntImages = baseMultiResolutionImageClass.getConstructor(Integer.TYPE, Image[].class);
                    return (Image)constructorIntImages.newInstance(0, images);
                }
                catch (Exception e) {
                    assert (false);
                    _LOG.log(Level.SEVERE, "During create BaseMultiResolutionImage for url=" + url, e);
                    return images[0];
                }
            }
            return ImageUtility.toBufferedImage(ResIcoAbstract.getImage(url), size);
        }
        Image img = ResIcoAbstract.getImage(url);
        double r = ResIcoAbstract.getDpiScaledRatio();
        if (Double.compare(r, 1.0) == 0) {
            return img;
        }
        try {
            Dimension d = ImageUtility.getImageDimension(url);
            int w = ResIcoAbstract.getDpiScaledValue((int)d.getWidth());
            int h = ResIcoAbstract.getDpiScaledValue((int)d.getHeight());
            return img.getScaledInstance(w, h, 4);
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "During read dimension for url=" + url, e);
            return img;
        }
    }

    private static Image getImage(URL url) {
        return ResIcoAbstract.getImage(url, 256, 256);
    }

    public static Image getImage(URL url, int widthIfSVG, int heightIfSVG) {
        String extension = FileUtility.getFileExt(url.getFile()).toLowerCase();
        if (extension.equals(".jpg") || extension.equals(".jpeg") || extension.equals(".gif") || extension.equals(".png")) {
            return Toolkit.getDefaultToolkit().getImage(url);
        }
        if (extension.equals(".svg")) {
            if (widthIfSVG == -1) {
                try {
                    double ratio = ImageUtility.getImageSVGRatio(url);
                    widthIfSVG = Double.isNaN(ratio) ? heightIfSVG : (int)((double)heightIfSVG * ratio);
                }
                catch (IOException e) {
                    _LOG.log(Level.SEVERE, "During read dimension for url=" + url, e);
                    widthIfSVG = heightIfSVG;
                }
            }
            return ImageUtility.getImageFromSVG(url, widthIfSVG, heightIfSVG);
        }
        _LOG.severe("Unknow image extention '" + extension + "'");
        return null;
    }
}

