/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.destination;

import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Failure;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import java.util.Map;

public class DestinationString
extends Destination {
    private StringBuffer _output;
    private int _limit;
    private int _limitRecord = -1;
    private int _cptRecord = 0;
    private boolean _doneHeader;

    public DestinationString() {
        this(-1, null);
    }

    public DestinationString(int limit) {
        this(limit, null);
    }

    public DestinationString(int limit, Layout layout) {
        this._limit = limit;
        this._output = this._limit > 0 ? new StringBuffer(this._limit + 100) : new StringBuffer();
        this._doneHeader = false;
        if (layout != null) {
            this.setLayout(layout);
        }
    }

    @Override
    public void configure(Map<String, Object> params, Layout layout) {
        String param = (String)params.get("Limit");
        if (param != null) {
            try {
                this._limit = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                Failure.OPEN.report(e);
            }
        } else {
            this._limit = -1;
        }
        if ((param = (String)params.get("LimitRecord")) != null) {
            try {
                this._limitRecord = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                Failure.OPEN.report(e);
            }
        } else {
            this._limitRecord = -1;
        }
        super.configure(params, layout);
    }

    @Override
    public void publish(Record record) {
        String msg;
        if (!this.isAcceptable(record)) {
            return;
        }
        try {
            msg = this.getLayout().format(record);
        }
        catch (Exception ex) {
            Failure.FORMAT.report(ex);
            return;
        }
        if (msg == null || msg.length() == 0) {
            return;
        }
        try {
            if (!this._doneHeader) {
                this._output.append(this.getLayout().getHead(this));
                this._doneHeader = true;
            }
            this._output.append(msg);
            ++this._cptRecord;
        }
        catch (Exception ex) {
            Failure.WRITE.report(ex);
        }
    }

    @Override
    public boolean isAcceptable(Record record) {
        if (record == null) {
            return false;
        }
        if (this._limit >= 0 && this._output.length() > this._limit) {
            return false;
        }
        if (this._limitRecord > 0 && this._limitRecord >= this._cptRecord) {
            return false;
        }
        return super.isAcceptable(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this._doneHeader) {
            this._output.append(this.getLayout().getTail(this));
        }
    }

    public String getString() {
        return this._output.toString();
    }

    public String toString() {
        return this._output.toString();
    }

    public int getNbrRecord() {
        return this._cptRecord;
    }
}

